/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ScriptQueryBuilder
extends AbstractQueryBuilder<ScriptQueryBuilder> {
    public static final String NAME = "script";
    private final Script script;

    public ScriptQueryBuilder(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("script cannot be null");
        }
        this.script = script;
    }

    public ScriptQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    public Script script() {
        return this.script;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject(NAME);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ScriptQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Script script = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    script = Script.parse(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[script] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    script = Script.parse(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[script] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_ARRAY) {
                throw new AssertionError((Object)("Impossible token received: " + token.name()));
            }
            throw new ParsingException(parser.getTokenLocation(), "[script] query does not support an array of scripts. Use a bool query with a clause per script instead.", new Object[0]);
        }
        if (script == null) {
            throw new ParsingException(parser.getTokenLocation(), "script must be provided with a [script] filter", new Object[0]);
        }
        return (ScriptQueryBuilder)((ScriptQueryBuilder)new ScriptQueryBuilder(script).boost(boost)).queryName(queryName);
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[script] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        FilterScript.Factory factory = context.compile(this.script, FilterScript.CONTEXT);
        SearchLookup lookup = context.lookup();
        FilterScript.LeafFactory filterScript = factory.newFactory(this.script.getParams(), lookup);
        return new ScriptQuery(this.script, filterScript, lookup);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.script);
    }

    @Override
    protected boolean doEquals(ScriptQueryBuilder other) {
        return Objects.equals(this.script, other.script);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    static class ScriptQuery
    extends Query {
        final Script script;
        final FilterScript.LeafFactory filterScript;
        final SearchLookup lookup;

        ScriptQuery(Script script, FilterScript.LeafFactory filterScript, SearchLookup lookup) {
            this.script = script;
            this.filterScript = filterScript;
            this.lookup = lookup;
        }

        public String toString(String field) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("ScriptQuery(");
            buffer.append(this.script);
            buffer.append(")");
            return buffer.toString();
        }

        public boolean equals(Object obj) {
            if (!this.sameClassAs(obj)) {
                return false;
            }
            ScriptQuery other = (ScriptQuery)((Object)obj);
            return Objects.equals(this.script, other.script);
        }

        public int hashCode() {
            int h = this.classHash();
            h = 31 * h + this.script.hashCode();
            return h;
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            return new ConstantScoreWeight(this, boost){

                public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                    final FilterScript leafScript = filterScript.newInstance(new DocValuesDocReader(lookup, context));
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(this, approximation){

                        public boolean matches() throws IOException {
                            leafScript.setDocument(this.approximation.docID());
                            return leafScript.execute();
                        }

                        public float matchCost() {
                            return 1000.0f;
                        }
                    };
                    ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                    return new Weight.DefaultScorerSupplier((Scorer)scorer);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return false;
                }
            };
        }
    }
}

