/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery.plan;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardRecoveryPlan;

public class PeerOnlyRecoveryPlannerService
implements RecoveryPlannerService {
    public static final RecoveryPlannerService INSTANCE = new PeerOnlyRecoveryPlannerService();

    @Override
    public void computeRecoveryPlan(ShardId shardId, @Nullable String shardStateIdentifier, Store.MetadataSnapshot sourceMetadata, Store.MetadataSnapshot targetMetadata, long startingSeqNo, int translogOps, IndexVersion targetVersion, boolean useSnapshots, boolean primaryRelocation, ActionListener<ShardRecoveryPlan> listener) {
        ActionListener.completeWith(listener, () -> {
            Store.RecoveryDiff recoveryDiff = sourceMetadata.recoveryDiff(targetMetadata);
            List<StoreFileMetadata> filesMissingInTarget = CollectionUtils.concatLists(recoveryDiff.missing, recoveryDiff.different);
            return new ShardRecoveryPlan(ShardRecoveryPlan.SnapshotFilesToRecover.EMPTY, filesMissingInTarget, recoveryDiff.identical, startingSeqNo, translogOps, sourceMetadata);
        });
    }
}

