/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetComponentTemplateAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_CAPABILITIES = Set.of("local_param_deprecated");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_component_template"), new RestHandler.Route(RestRequest.Method.GET, "/_component_template/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_component_template/{name}"));
    }

    @Override
    public String getName() {
        return "get_component_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetComponentTemplateAction.Request getRequest = new GetComponentTemplateAction.Request(RestUtils.getMasterNodeTimeout(request), request.param("name"));
        getRequest.includeDefaults(request.paramAsBoolean("include_defaults", false));
        RestUtils.consumeDeprecatedLocalParameter(request);
        boolean implicitAll = getRequest.name() == null;
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(GetComponentTemplateAction.INSTANCE, getRequest, new RestToXContentListener<GetComponentTemplateAction.Response>((RestChannel)channel, r -> {
            boolean templateExists = !r.getComponentTemplates().isEmpty();
            return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
        }));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public Set<String> supportedCapabilities() {
        return SUPPORTED_CAPABILITIES;
    }
}

