/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestGetIndexTemplateAction
extends BaseRestHandler {
    private static final Set<String> CAPABILITIES = Set.of("local_param_deprecated");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_template"), new RestHandler.Route(RestRequest.Method.GET, "/_template/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_template/{name}"));
    }

    @Override
    public String getName() {
        return "get_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] names = Strings.splitStringByCommaToArray(request.param("name"));
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(RestUtils.getMasterNodeTimeout(request), names);
        RestUtils.consumeDeprecatedLocalParameter(request);
        boolean implicitAll = getIndexTemplatesRequest.names().length == 0;
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(GetIndexTemplatesAction.INSTANCE, getIndexTemplatesRequest, new RestToXContentListener<GetIndexTemplatesResponse>((RestChannel)channel, r -> {
            boolean templateExists = !r.getIndexTemplates().isEmpty();
            return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
        }));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public Set<String> supportedCapabilities() {
        return CAPABILITIES;
    }
}

