/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.admin.indices.RestCreateIndexAction;

public class RestPutIndexTemplateAction
extends BaseRestHandler {
    public static final String DEPRECATION_WARNING = "Legacy index templates are deprecated in favor of composable templates.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder(RestRequest.Method.POST, "/_template/{name}").deprecateAndKeep(DEPRECATION_WARNING).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/_template/{name}").deprecateAndKeep(DEPRECATION_WARNING).build());
    }

    @Override
    public String getName() {
        return "put_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutIndexTemplateRequest putRequest = new PutIndexTemplateRequest(request.param("name"));
        putRequest.patterns(Arrays.asList(request.paramAsStringArray("index_patterns", Strings.EMPTY_ARRAY)));
        putRequest.order(request.paramAsInt("order", putRequest.order()));
        putRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        putRequest.create(request.paramAsBoolean("create", false));
        putRequest.cause(request.param("cause", ""));
        putRequest.source(RestCreateIndexAction.prepareMappings((Map)XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2()));
        return channel -> client.admin().indices().putTemplate(putRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

