/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.SearchShardTarget;

public class SearchException
extends ElasticsearchException
implements ElasticsearchWrapperException {
    private final SearchShardTarget shardTarget;

    protected SearchException(SearchShardTarget shardTarget, String msg) {
        super(msg, new Object[0]);
        this.shardTarget = shardTarget;
    }

    public SearchException(SearchShardTarget shardTarget, String msg, Throwable cause) {
        super(msg, Objects.requireNonNull(cause, "cause must not be null"), new Object[0]);
        this.shardTarget = shardTarget;
    }

    public SearchException(StreamInput in) throws IOException {
        super(in);
        this.shardTarget = in.readBoolean() ? new SearchShardTarget(in) : null;
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        if (this.shardTarget == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.shardTarget.writeTo(out);
        }
    }

    public SearchShardTarget shard() {
        return this.shardTarget;
    }
}

