/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.function.IntConsumer;
import java.util.function.Supplier;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract sealed class AggregationReduceContext {
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final Supplier<Boolean> isCanceled;
    @Nullable
    private final AggregationBuilder builder;
    private final AggregatorFactories.Builder subBuilders;

    private AggregationReduceContext(BigArrays bigArrays, ScriptService scriptService, Supplier<Boolean> isCanceled, AggregatorFactories.Builder subBuilders) {
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.isCanceled = isCanceled;
        this.builder = null;
        this.subBuilders = subBuilders;
    }

    private AggregationReduceContext(BigArrays bigArrays, ScriptService scriptService, Supplier<Boolean> isCanceled, AggregationBuilder builder) {
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.isCanceled = isCanceled;
        this.builder = builder;
        this.subBuilders = builder.factoriesBuilder;
    }

    public abstract boolean isFinalReduce();

    public final BigArrays bigArrays() {
        return this.bigArrays;
    }

    public final ScriptService scriptService() {
        return this.scriptService;
    }

    public final Supplier<Boolean> isCanceled() {
        return this.isCanceled;
    }

    public AggregationBuilder builder() {
        return this.builder;
    }

    public abstract PipelineAggregator.PipelineTree pipelineTreeRoot();

    public final void consumeBucketsAndMaybeBreak(int size) {
        if (this.isCanceled.get().booleanValue()) {
            throw new TaskCancelledException("Cancelled");
        }
        this.consumeBucketCountAndMaybeBreak(size);
    }

    protected abstract void consumeBucketCountAndMaybeBreak(int var1);

    public final AggregationReduceContext forAgg(String name) {
        for (AggregationBuilder b : this.subBuilders.getAggregatorFactories()) {
            if (!b.getName().equals(name)) continue;
            return this.forSubAgg(b);
        }
        throw new IllegalArgumentException("reducing an aggregation [" + name + "] that wasn't requested");
    }

    protected abstract AggregationReduceContext forSubAgg(AggregationBuilder var1);

    public static final class ForFinal
    extends AggregationReduceContext {
        private final IntConsumer multiBucketConsumer;
        private final PipelineAggregator.PipelineTree pipelineTreeRoot;

        public ForFinal(BigArrays bigArrays, ScriptService scriptService, Supplier<Boolean> isCanceled, AggregatorFactories.Builder builders, IntConsumer multiBucketConsumer) {
            super(bigArrays, scriptService, isCanceled, builders);
            this.multiBucketConsumer = multiBucketConsumer;
            this.pipelineTreeRoot = builders == null ? null : builders.buildPipelineTree();
        }

        public ForFinal(BigArrays bigArrays, ScriptService scriptService, Supplier<Boolean> isCanceled, AggregationBuilder builder, IntConsumer multiBucketConsumer, PipelineAggregator.PipelineTree pipelineTreeRoot) {
            super(bigArrays, scriptService, isCanceled, builder);
            this.multiBucketConsumer = multiBucketConsumer;
            this.pipelineTreeRoot = pipelineTreeRoot;
        }

        @Override
        public boolean isFinalReduce() {
            return true;
        }

        @Override
        protected void consumeBucketCountAndMaybeBreak(int size) {
            this.multiBucketConsumer.accept(size);
        }

        @Override
        public PipelineAggregator.PipelineTree pipelineTreeRoot() {
            return this.pipelineTreeRoot;
        }

        @Override
        protected AggregationReduceContext forSubAgg(AggregationBuilder sub) {
            return new ForFinal(this.bigArrays(), this.scriptService(), this.isCanceled(), sub, this.multiBucketConsumer, this.pipelineTreeRoot);
        }
    }

    public static final class ForPartial
    extends AggregationReduceContext {
        private final IntConsumer multiBucketConsumer;

        public ForPartial(BigArrays bigArrays, ScriptService scriptService, Supplier<Boolean> isCanceled, AggregatorFactories.Builder builders, IntConsumer multiBucketConsumer) {
            super(bigArrays, scriptService, isCanceled, builders);
            this.multiBucketConsumer = multiBucketConsumer;
        }

        public ForPartial(BigArrays bigArrays, ScriptService scriptService, Supplier<Boolean> isCanceled, AggregationBuilder builder, IntConsumer multiBucketConsumer) {
            super(bigArrays, scriptService, isCanceled, builder);
            this.multiBucketConsumer = multiBucketConsumer;
        }

        @Override
        public boolean isFinalReduce() {
            return false;
        }

        @Override
        protected void consumeBucketCountAndMaybeBreak(int size) {
            this.multiBucketConsumer.accept(size);
        }

        @Override
        public PipelineAggregator.PipelineTree pipelineTreeRoot() {
            return null;
        }

        @Override
        protected AggregationReduceContext forSubAgg(AggregationBuilder sub) {
            return new ForPartial(this.bigArrays(), this.scriptService(), this.isCanceled(), sub, this.multiBucketConsumer);
        }
    }

    public static interface Builder {
        public AggregationReduceContext forPartialReduction();

        public AggregationReduceContext forFinalReduction();
    }
}

