/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ThreadPoolInfo
implements ReportingService.Info,
Iterable<ThreadPool.Info> {
    private final List<ThreadPool.Info> infos;

    public ThreadPoolInfo(List<ThreadPool.Info> infos) {
        this.infos = List.copyOf(infos);
    }

    public ThreadPoolInfo(StreamInput in) throws IOException {
        this.infos = in.readCollectionAsImmutableList(ThreadPool.Info::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.infos);
    }

    @Override
    public Iterator<ThreadPool.Info> iterator() {
        return this.infos.iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("thread_pool");
        for (ThreadPool.Info info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String THREAD_POOL = "thread_pool";

        Fields() {
        }
    }
}

