/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum SSLMessages {
    ERR_AGGREGATE_TRUST_MANAGER_NONE_TRUSTED("Certificate {0} was not trusted by any of the configured trust managers.  The trust manager messages were:  {1}"),
    ERR_CERTIFICATE_REJECTED_BY_END_OF_STREAM("Certificate {0} cannot be trusted because the end of the standard input stream was reached without finding information about whether to trust the presented certificate."),
    ERR_CERTIFICATE_REJECTED_BY_USER("The user rejected certificate {0}."),
    ERR_HOSTNAME_NOT_FOUND("The presented certificate ''{0}'' did not contain any of the acceptable addresses in the CN subject attribute or in a subjectAltName extension."),
    ERR_HOST_NAME_SSL_SOCKET_VERIFIER_EXCEPTION("Unable to verify an attempt to establish a secure connection to ''{0}:{1,number,0}'' because an unexpected error was encountered during validation processing:  {2}"),
    ERR_HOST_NAME_SSL_SOCKET_VERIFIER_HOSTNAME_NOT_FOUND("Hostname verification failed because the expected hostname ''{0}'' was not found in peer certificate ''{1}''."),
    ERR_HOST_NAME_SSL_SOCKET_VERIFIER_NO_PEER_CERTS("Unable to verify an attempt to establish a secure connection to ''{0}:{1,number,0}'' because no peer certificates are available."),
    ERR_HOST_NAME_SSL_SOCKET_VERIFIER_NO_SESSION("Unable to verify an attempt to establish a secure connection to ''{0}:{1,number,0}'' because no session information is available for the connection."),
    ERR_HOST_NAME_SSL_SOCKET_VERIFIER_PEER_NOT_X509("Unable to verify an attempt to establish a secure connection to ''{0}:{1,number,0}'' because the peer certificate was not an X.509 certificate.  The reported certificate type is ''{2}''."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CACERTS_NOT_FOUND_NO_EXCEPTION("Unable to locate the cacerts key store file containing the JVM''s default set of trusted issuers."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CACERTS_NOT_FOUND_WITH_EXCEPTION("Unable to locate a valid key store file containing the JVM''s default set of trusted issuers.  One or more errors were encountered during processing."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CANNOT_ERROR_LOADING_KEYSTORE("Unable to parse the contents of file ''{0}'' as a key store:  {1}"),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CANNOT_FIND_ISSUER("Unable to find a valid issuer certificate for certificate with subject ''{0}'' in the JVM-default trust store."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CANNOT_INSTANTIATE_KEYSTORE("Unable to instantiate a key store of type ''{0}'':  {1}"),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CERT_EXPIRED("The presented certificate chain containing certificates {0} cannot be trusted because certificate ''{1}'' expired at {2}."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_CERT_NOT_YET_VALID("The presented certificate chain containing certificates {0} cannot be trusted because certificate ''{1}'' will not become valid until {2}."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_ERROR_ITERATING_THROUGH_CACERTS("An unexpected error occurred while attempting to iterate through certificates in the key store loaded from file ''{0}'':  {1}"),
    ERR_JVM_DEFAULT_TRUST_MANAGER_INVALID_JAVA_HOME("System property ''{0}'' value ''{1}'' is not a valid path to a directory on the local filesystem."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_LOAD_ERROR("While examining file ''{0}'', the error encountered was:  {1}"),
    ERR_JVM_DEFAULT_TRUST_MANAGER_NO_CERTS_IN_CHAIN("The certificate chain cannot be trusted because it was null or empty."),
    ERR_JVM_DEFAULT_TRUST_MANAGER_NO_JAVA_HOME("Unable to determine the location of the Java installation because the ''{0}'' system property is not defined."),
    ERR_JVM_DEFAULT_TRUST_MANGER_NO_TRUSTED_ISSUER_FOUND("The presented certificate chain containing certificates {0} cannot be trusted because none of the certificates in that chain were found in the JVM''s default set of trusted issuers."),
    ERR_KEYSTORE_CANNOT_GET_KEY_MANAGERS("Unable to obtain key managers for key store file ''{0}'' using format ''{1}'':  {2}"),
    ERR_KEYSTORE_CANNOT_LOAD("Unable to load key store ''{0}'' of type ''{1}'':  {2}"),
    ERR_KEYSTORE_CANNOT_VALIDATE("An unexpected error occurred while attempting to validate that file ''{0}'' can be used as a valid certificate key store:  {1}"),
    ERR_KEYSTORE_CERT_EXPIRED("Unable to use the private key entry in alias ''{0}'' because its certificate chain contains certificate ''{1}'' that expired at {2}."),
    ERR_KEYSTORE_CERT_NOT_YET_VALID("Unable to use the private key entry in alias ''{0}'' because its certificate chain contains certificate ''{1}'' that will not be valid until {2}."),
    ERR_KEYSTORE_ENTRY_NOT_PRIVATE_KEY("Entry ''{0}'' in key store file ''{1}'' is not a private key entry."),
    ERR_KEYSTORE_NO_ENTRY_WITH_ALIAS("Key store file ''{0}'' does not contain an entry with the requested alias of ''{1}''."),
    ERR_KEYSTORE_NO_PRIVATE_KEY_ENTRIES("File ''{0}'' cannot be used as a certificate key store because it does not contain any private key entries."),
    ERR_KEYSTORE_NO_SUCH_FILE("Key store file ''{0}'' does not exist."),
    ERR_KEYSTORE_NO_VALID_PRIVATE_KEY_ENTRIES("File ''{0}'' cannot be used as a certificate key store because it does not contain any private key entries that are currently valid.  {1}"),
    ERR_NO_ENABLED_SSL_CIPHER_SUITES_AVAILABLE_FOR_SOCKET("None of the configured set of enabled SSL cipher suites could be configured for use with the SSL socket.  The currently-enabled cipher suites are:  {0}.  The SSL socket indicated its supported cipher suites are:  {1}.  You may explicitly configure the enabled protocols using the {2} system property or by calling the {3} method."),
    ERR_NO_ENABLED_SSL_PROTOCOLS_AVAILABLE_FOR_SOCKET("None of the configured set of enabled SSL protocols could be configured for use with the SSL socket.  The currently-enabled protocols are:  {0}.  The SSL socket indicated its supported protocols are:  {1}.  You may explicitly configure the enabled protocols using the {2} system property or by calling the {3} method."),
    ERR_NULL_TRUST_MANAGER_CERT_NOT_TRUSTED("The null trust manager never trusts any certificate."),
    ERR_PCKS11_NO_SUCH_PROVIDER_CLASS("Unable to load PKCS #11 provider class ''{0}'':  {1}.  This suggests that the provider class is not available in the JVM''s classpath."),
    ERR_PEM_FILE_KEY_MANAGER_CANNOT_COMPUTE_ALIAS("An unexpected error occurred while attempting to compute a {0} fingerprint of the end entity certificate to use as the alias:  {1}"),
    ERR_PEM_FILE_KEY_MANAGER_CANNOT_DECODE_CERT("Unable to initialize a PEM file key manager because although certificate ''{0}'' was successfully read from PEM file ''{1}'', an unexpected error occurred while attempting to convert that certificate to a Java X.509 certificate: {2}"),
    ERR_PEM_FILE_KEY_MANAGER_CANNOT_DECODE_KEY("Unable to initialize a PEM file key manager because while a PKCS #8 private key was successfully read from PEM file ''{0}'', an unexpected error occurred while attempting to convert it to a Java private key:  {1}"),
    ERR_PEM_FILE_KEY_MANAGER_EMPTY_CERT_FILE("Unable to initialize a PEM file key manager because file ''{0}'' does not contain any X.509 certificates."),
    ERR_PEM_FILE_KEY_MANAGER_EMPTY_KEY_FILE("Unable to initialize a PEM file key manager because file ''{0}'' does not contain a PKCS #8 private key."),
    ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_CERT("Unable to initialize a PEM file key manager because an error occurred while attempting to read an X.509 certificate from file ''{0}'':  {1}"),
    ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_FROM_FILE("Unable to initialize a PEM file key manager because an I/O error was encountered while trying to read from file ''{0}'':  {1}"),
    ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_KEY("Unable to initialize a PEM file key manager because an error occurred while attempting to read a PKCS #8 private key from file ''{0}'':  {1}"),
    ERR_PEM_FILE_KEY_MANAGER_MULTIPLE_KEYS_IN_FILE("Unable to initialize a PEM file key manager because file ''{0}'' contains multiple private keys."),
    ERR_PEM_FILE_KEY_MANAGER_NO_SUCH_CERT_FILE("Unable to initialize a PEM file key manager because certificate file ''{0}'' does not exist."),
    ERR_PEM_FILE_KEY_MANAGER_NO_SUCH_KEY_FILE("Unable to initialize a PEM file key manager because private key file ''{0}'' does not exist."),
    ERR_PEM_FILE_KEY_MANAGER_SUBSEQUENT_CERT_NOT_ISSUER("Unable to initialize a PEM file key manager because certificate ''{0}'' read from PEM file ''{1}'' is not the issuer for the previous certificate ''{2}'' that was read.  Each subsequent certificate in the chain must be the issuer for the previous certificate."),
    ERR_PEM_FILE_TRUST_MANAGER_CANNOT_GET_DIGEST("Unable to initialize a PEM file trust manager because an error occurred while preparing to generate ''{0}'' digests:  {1}"),
    ERR_PEM_FILE_TRUST_MANAGER_CANNOT_PARSE_CERT_FROM_CHAIN("An unexpected error occurred while trying to parse certificate ''{0}'':  {1}"),
    ERR_PEM_FILE_TRUST_MANAGER_CERT_NOT_ISSUER("Certificate ''{0}'' is not the issuer for the previous certificate ''{1}'' in the chain."),
    ERR_PEM_FILE_TRUST_MANAGER_CERT_NOT_VALID("Certificate ''{0}'' is outside of the validity window.  That certificate is valid from {1} to {2}."),
    ERR_PEM_FILE_TRUST_MANAGER_CLIENT_NOT_TRUSTED("Unable to trust the presented client certificate chain:  {0}"),
    ERR_PEM_FILE_TRUST_MANAGER_EMPTY_CHAIN("The certificate chain is empty."),
    ERR_PEM_FILE_TRUST_MANAGER_EMPTY_FILE("Unable to initialize a PEM file trust manager because target file ''{0}'' does not contain any X.509 certificates."),
    ERR_PEM_FILE_TRUST_MANAGER_ERROR_PARSING_CERT("Unable to initialize a PEM file trust manager because an error occurred while trying to parse data read from file ''{0}'' as an X.509 certificate:  {1}"),
    ERR_PEM_FILE_TRUST_MANAGER_ERROR_PROCESSING_FILE("Unable to initialize a PEM file trust manager because an unexpected error occurred while processing file ''{0}'':  {1}"),
    ERR_PEM_FILE_TRUST_MANAGER_ERROR_READING_FILE("Unable to initialize a PEM file trust manager because an error occurred while trying to read from file ''{0}'':  {1}"),
    ERR_PEM_FILE_TRUST_MANAGER_NOT_TRUSTED("Certificate ''{0}'' nor any of its issuers was found in the PEM file trust store."),
    ERR_PEM_FILE_TRUST_MANAGER_NO_SUCH_FILE("Unable to initialize a PEM file trust manager because target file ''{0}'' does not exist."),
    ERR_PEM_FILE_TRUST_MANAGER_SERVER_NOT_TRUSTED("Unable to trust the presented client certificate chain:  {0}"),
    ERR_PKCS11_CANNOT_ACCESS("Unable to access the PKCS #11 key store:  {0}"),
    ERR_PKCS11_CANNOT_CONFIGURE_PROVIDER("An error occurred while attempting to configure the PKCS #11 provider of type ''{0}'' using configuration file ''{1}'':  {2}"),
    ERR_PKCS11_CANNOT_GET_KEY_MANAGERS("Unable to obtain key managers for the PKCS #11 key store:  {0}"),
    ERR_PKCS11_CANNOT_INFER_PROVIDER_CLASS("Unable to determine which provider class should be used to interact with a PKCS #11 token.  None of the providers already loaded in the JVM appear to support PKCS #11, and the default provider class of ''{0}'' is not available."),
    ERR_PKCS11_CANNOT_INVOKE_DEFAULT_CONSTRUCTOR("Unable to create an instance of provider class ''{0}'' to use to access a ''{1}'' key store because an error occurred while invoking its default constructor:  {2}"),
    ERR_PKCS11_CANNOT_INVOKE_STRING_CONSTRUCTOR("Unable to create an instance of provider class ''{0}'' with configuration file ''{1}'' to use to access a ''{2}'' key store because an error occurred while invoking the constructor:  {3}"),
    ERR_PKCS11_CONFIGURED_PROVIDER_NO_KS_TYPE("Unable to use a provider instance of type ''{0}'' because it does not advertise support for the ''{1}'' key store type after configuring it using configuration file ''{2}''."),
    ERR_PKCS11_DEFAULT_CONSTRUCTOR_NO_KS_TYPE("Unable to use a provider instance of type ''{0}'' created from the default constructor because that instance does not advertise support for the ''{1}'' key store type.  You may need to either specify a configuration file or pre-configure the provider in the JVM."),
    ERR_PKCS11_NO_DEFAULT_CONSTRUCTOR_NO_CONFIG("Unable to create an instance of provider class ''{0}'' to use to access a ''{1}'' key store because that provider class does not offer a default constructor and no provider configuration file was defined."),
    ERR_PKCS11_NO_STRING_CONSTRUCTOR("Unable to create a provider of type ''{0}'' with configuration file ''{1}'' to use to access a ''{2}'' key store because that class does not either offer a default constructor and a configure method or a constructor that takes a single string argument."),
    ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_INPUT("The shutdownInput method is not supported for SSL sockets."),
    ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_OUTPUT("The shutdownOutput method is not supported for SSL sockets."),
    ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED("Sending urgent data is not supported for SSL sockets."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_ANON_AUTH("The cipher suite uses anonymous authentication."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_EXPORT_ENCRYPTION("The cipher suite uses a weakened export-grade encryption."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_INIT_ERROR("ERROR:  An unexpected error occurred while trying to initialize the TLS cipher suite selector:  {0}"),
    ERR_TLS_CIPHER_SUITE_SELECTOR_LEGACY_SSL_PROTOCOL("The cipher suite uses a legacy SSL protocol."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG("The cipher suite uses the non-recommended {0} bulk encryption algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_DIGEST_ALG("The cipher suite uses the non-recommended {0} message digest algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG("The cipher suite uses the non-recommended {0} key exchange algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_BE_ALG("The cipher suite uses a non-recommended bulk encryption algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_DIGEST_ALG("The cipher suite uses a non-recommended message digest algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_KE_ALG("The cipher suite uses a non-recommended key exchange algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_NULL_COMPONENT("The cipher suite uses a NULL key exchange, authentication, bulk encryption, or message digest algorithm."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_PSK("The cipher suite relies on a pre-shared key."),
    ERR_TLS_CIPHER_SUITE_SELECTOR_UNRECOGNIZED_PROTOCOL("The cipher suite uses an unrecognized protocol."),
    ERR_TRUSTSTORE_CANNOT_GET_TRUST_MANAGERS("Unable to obtain trust managers for trust store file ''{0}'' using format ''{1}'':  {2}"),
    ERR_TRUSTSTORE_CANNOT_LOAD("Unable to load trust store ''{0}'' of type ''{1}'':  {2}"),
    ERR_TRUSTSTORE_NO_SUCH_FILE("Trust store file ''{0}'' does not exist."),
    ERR_TRUSTSTORE_UNSUPPORTED_FORMAT("Unsupported trust store format ''{0}''."),
    ERR_VALIDITY_TOO_EARLY("The presented certificate ''{0}'' will not be valid until {1}."),
    ERR_VALIDITY_TOO_LATE("The presented certificate ''{0}'' expired on {1}."),
    INFO_PROMPT_CLIENT_HEADING("The client presented the following certificate chain:"),
    INFO_PROMPT_ISSUER_SUBJECT("Issuer {0,number,0} Subject: {1}"),
    INFO_PROMPT_MESSAGE("Do you wish to trust this certificate?  Enter ''y'' or ''n'':"),
    INFO_PROMPT_SERVER_HEADING("The server presented the following certificate chain:"),
    INFO_PROMPT_SHA1_FINGERPRINT("SHA-1 Fingerprint: {0}"),
    INFO_PROMPT_SHA256_FINGERPRINT("256-bit SHA-2 Fingerprint: {0}"),
    INFO_PROMPT_SUBJECT("Subject: {0}"),
    INFO_PROMPT_VALID_FROM("Valid From: {0}"),
    INFO_PROMPT_VALID_TO("Valid Until: {0}"),
    INFO_TLS_CIPHER_SUITE_SELECTOR_TOOL_DESC("Provides information about the TLS cipher suites that are supported by the JVM and selects a recommended set of suites for secure communication."),
    WARN_PROMPT_PROCESSOR_BC_DISALLOWED_INTERMEDIATE("WARNING:  Issuer certificate ''{0}'' has a basic constraints extension that indicates there should not be any intermediate CA certificates between it and the end entity certificate, but one or more intermediate CA certificates were found ahead of it in the chain."),
    WARN_PROMPT_PROCESSOR_BC_NOT_CA("WARNING:  Issuer certificate ''{0}'' has a basic constraints extension that indicates the certificate should not be trusted as an issuer certificate."),
    WARN_PROMPT_PROCESSOR_BC_TOO_MANY_INTERMEDIATES("WARNING:  Issuer certificate ''{0}'' has a basic constraints extension that indicates there should be at most {1,number,0} intermediate CA certificate(s) between it and the end entity certificate, but {2,number,0} intermediate CA certificates were found."),
    WARN_PROMPT_PROCESSOR_CERT_BAD_SIGNATURE("WARNING:  {0} certificate ''{1}'' has an invalid signature.  This may mean that the certificate has been forged or that it has been altered since it was signed."),
    WARN_PROMPT_PROCESSOR_CERT_EXPIRED("WARNING:  {0} certificate ''{1}'' expired on {2} ({3} ago)."),
    WARN_PROMPT_PROCESSOR_CERT_IS_SELF_SIGNED("WARNING:  The certificate is self-signed."),
    WARN_PROMPT_PROCESSOR_CERT_NOT_YET_VALID("WARNING:  {0} certificate ''{1}'' will not be valid until {2} ({3} from now)."),
    WARN_PROMPT_PROCESSOR_CHAIN_ISSUER_MISMATCH("WARNING:  The presented certificate chain has certificate ''{0}'' immediately following certificate ''{1}'', but the former certificate is not the issuer for the latter."),
    WARN_PROMPT_PROCESSOR_CHAIN_NOT_COMPLETE("WARNING:  The presented certificate chain is not complete.  It ends with certificate ''{0}'', which is not self-signed."),
    WARN_PROMPT_PROCESSOR_DATE_TIME("{0} at {1}"),
    WARN_PROMPT_PROCESSOR_EKU_MISSING_CLIENT_AUTH("WARNING:  Client certificate ''{0}'' has an extended key usage extension that does not include the clientAuth usage.  This certificate is not intended to be used as a TLS client certificate."),
    WARN_PROMPT_PROCESSOR_EKU_MISSING_SERVER_AUTH("WARNING:  Server certificate ''{0}'' has an extended key usage extension that does not include the serverAuth usage.  This certificate is not intended to be used as a TLS server certificate."),
    WARN_PROMPT_PROCESSOR_KU_NO_KEY_CERT_SIGN("WARNING:  Issuer certificate ''{0}'' has a key usage extension that does not include the keyCertSign usage.  This indicates that the certificate should not be trusted as an issuer certificate."),
    WARN_PROMPT_PROCESSOR_LABEL_CLIENT("Client"),
    WARN_PROMPT_PROCESSOR_LABEL_ISSUER("Issuer"),
    WARN_PROMPT_PROCESSOR_LABEL_SERVER("Server"),
    WARN_PROMPT_PROCESSOR_MULTIPLE_ADDRESSES_NOT_MATCHED("WARNING:  Server certificate ''{0}'' appears to be intended for use in a server with one of the following addresses:  {1}.  None of these addresses matches the address used by the client."),
    WARN_PROMPT_PROCESSOR_NO_BC_EXTENSION("WARNING:  Issuer certificate ''{0}'' does not have a basic constraints extension.  This certificate was likely not intended to be used as an issuer certificate."),
    WARN_PROMPT_PROCESSOR_SINGLE_ADDRESS_NOT_MATCHED("WARNING:  Server certificate ''{0}'' appears to be intended for use in a server with address {1}, which does not match the address used by the client.");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final Object[] NO_ARGS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<SSLMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<SSLMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private SSLMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(NO_ARGS);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    public String toString() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                s = this.defaultText;
            } else {
                try {
                    s = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s);
            }
        }
        return s;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        NO_ARGS = new Object[0];
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-ssl");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

