/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.ibmwatsonx;

import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.ibmwatsonx.IbmWatsonxErrorResponseEntity;

public class IbmWatsonxResponseHandler
extends BaseResponseHandler {
    public IbmWatsonxResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, IbmWatsonxErrorResponseEntity::fromResponse);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 404) {
            throw new RetryException(false, this.buildError(IbmWatsonxResponseHandler.resourceNotFoundError(request), request, result));
        }
        if (statusCode == 403) {
            throw new RetryException(false, this.buildError("Received a permission denied error status code", request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode == 400) {
            throw new RetryException(false, this.buildError("Received a bad request status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    private static String resourceNotFoundError(Request request) {
        return Strings.format((String)"Resource not found at [%s]", (Object[])new Object[]{request.getURI()});
    }
}

