/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion;

import java.util.List;
import java.util.Optional;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.external.request.amazonbedrock.completion.AmazonBedrockConverseRequestEntity;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.Message;

public final class AmazonBedrockConverseUtils {
    public static List<Message> getConverseMessageList(List<String> texts) {
        return texts.stream().map(text -> (ContentBlock)ContentBlock.builder().text(text).build()).map(content -> (Message)Message.builder().role("user").content(new ContentBlock[]{content}).build()).toList();
    }

    public static Optional<InferenceConfiguration> inferenceConfig(AmazonBedrockConverseRequestEntity request) {
        if (request.temperature() != null || request.topP() != null || request.maxTokenCount() != null) {
            InferenceConfiguration.Builder builder = InferenceConfiguration.builder();
            if (request.temperature() != null) {
                builder.temperature(Float.valueOf(request.temperature().floatValue()));
            }
            if (request.topP() != null) {
                builder.topP(Float.valueOf(request.topP().floatValue()));
            }
            if (request.maxTokenCount() != null) {
                builder.maxTokens(request.maxTokenCount());
            }
            return Optional.of((InferenceConfiguration)builder.build());
        }
        return Optional.empty();
    }

    @Nullable
    public static List<String> additionalTopK(@Nullable Double topK) {
        if (topK == null) {
            return null;
        }
        return List.of(Strings.format((String)"{\"top_k\":%f}", (Object[])new Object[]{Float.valueOf(topK.floatValue())}));
    }
}

