/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.cohere;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankTaskSettings;

public record CohereRerankRequestEntity(String model, String query, List<String> documents, CohereRerankTaskSettings taskSettings) implements ToXContentObject
{
    private static final String DOCUMENTS_FIELD = "documents";
    private static final String QUERY_FIELD = "query";
    private static final String MODEL_FIELD = "model";

    public CohereRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(documents);
        Objects.requireNonNull(taskSettings);
    }

    public CohereRerankRequestEntity(String query, List<String> input, CohereRerankTaskSettings taskSettings, String model) {
        this(model, query, input, taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_FIELD, this.model);
        builder.field(QUERY_FIELD, this.query);
        builder.field(DOCUMENTS_FIELD, this.documents);
        if (this.taskSettings.getDoesReturnDocuments() != null) {
            builder.field("return_documents", this.taskSettings.getDoesReturnDocuments());
        }
        if (this.taskSettings.getTopNDocumentsOnly() != null) {
            builder.field("top_n", this.taskSettings.getTopNDocumentsOnly());
        }
        if (this.taskSettings.getMaxChunksPerDoc() != null) {
            builder.field("max_chunks_per_doc", this.taskSettings.getMaxChunksPerDoc());
        }
        builder.endObject();
        return builder;
    }
}

