/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.googlevertexai;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.googlevertexai.GoogleVertexAiRequest;
import org.elasticsearch.xpack.inference.external.request.googlevertexai.GoogleVertexAiRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankModel;

public class GoogleVertexAiRerankRequest
implements GoogleVertexAiRequest {
    private final GoogleVertexAiRerankModel model;
    private final String query;
    private final List<String> input;

    public GoogleVertexAiRerankRequest(String query, List<String> input, GoogleVertexAiRerankModel model) {
        this.model = Objects.requireNonNull(model);
        this.query = Objects.requireNonNull(query);
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new GoogleVertexAiRerankRequestEntity(this.query, this.input, this.model.getServiceSettings().modelId(), this.model.getTaskSettings().topN())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    public void decorateWithAuth(HttpPost httpPost) {
        GoogleVertexAiRequest.decorateWithBearerToken(httpPost, this.model.getSecretSettings());
    }

    public GoogleVertexAiRerankModel model() {
        return this.model;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

