/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.ibmwatsonx;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankTaskSettings;

public record IbmWatsonxRerankRequestEntity(String query, List<String> inputs, IbmWatsonxRerankTaskSettings taskSettings, String modelId, String projectId) implements ToXContentObject
{
    private static final String INPUTS_FIELD = "inputs";
    private static final String QUERY_FIELD = "query";
    private static final String MODEL_ID_FIELD = "model_id";
    private static final String PROJECT_ID_FIELD = "project_id";

    public IbmWatsonxRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(modelId);
        Objects.requireNonNull(projectId);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        builder.field(QUERY_FIELD, this.query);
        builder.startArray(INPUTS_FIELD);
        for (String input : this.inputs) {
            builder.startObject();
            builder.field("text", input);
            builder.endObject();
        }
        builder.endArray();
        builder.field(PROJECT_ID_FIELD, this.projectId);
        builder.startObject("parameters");
        if (this.taskSettings.getTruncateInputTokens() != null) {
            builder.field("truncate_input_tokens", this.taskSettings.getTruncateInputTokens());
        }
        builder.startObject("return_options");
        if (this.taskSettings.getDoesReturnDocuments() != null) {
            builder.field(INPUTS_FIELD, this.taskSettings.getDoesReturnDocuments());
        }
        if (this.taskSettings.getTopNDocumentsOnly() != null) {
            builder.field("top_n", this.taskSettings.getTopNDocumentsOnly());
        }
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

