/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.elastic;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;

public class ElasticInferenceServiceErrorResponseEntity
extends ErrorResponse {
    private static final Logger logger = LogManager.getLogger(ElasticInferenceServiceErrorResponseEntity.class);

    private ElasticInferenceServiceErrorResponseEntity(String errorMessage) {
        super(errorMessage);
    }

    public static ErrorResponse fromResponse(HttpResult response) {
        return ElasticInferenceServiceErrorResponseEntity.fromParser((CheckedSupplier<XContentParser, IOException>)((CheckedSupplier)() -> XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body())));
    }

    public static ErrorResponse fromString(String response) {
        return ElasticInferenceServiceErrorResponseEntity.fromParser((CheckedSupplier<XContentParser, IOException>)((CheckedSupplier)() -> XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ErrorResponse fromParser(CheckedSupplier<XContentParser, IOException> jsonParserFactory) {
        try (XContentParser jsonParser = (XContentParser)jsonParserFactory.get();){
            Map responseMap = jsonParser.map();
            String error = (String)responseMap.get("error");
            if (error == null) return ErrorResponse.UNDEFINED_ERROR;
            ElasticInferenceServiceErrorResponseEntity elasticInferenceServiceErrorResponseEntity = new ElasticInferenceServiceErrorResponseEntity(error);
            return elasticInferenceServiceErrorResponseEntity;
        }
        catch (Exception e) {
            logger.debug("Failed to parse error response", (Throwable)e);
        }
        return ErrorResponse.UNDEFINED_ERROR;
    }
}

