/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.License;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformDeprecations;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.utils.SourceDestValidations;

public class TransportValidateTransformAction
extends HandledTransportAction<ValidateTransformAction.Request, ValidateTransformAction.Response> {
    private final Client client;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Settings nodeSettings;
    private final SourceDestValidator sourceDestValidator;

    @Inject
    public TransportValidateTransformAction(TransportService transportService, ActionFilters actionFilters, Client client, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, IngestService ingestService) {
        super("cluster:admin/transform/validate", transportService, actionFilters, ValidateTransformAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeSettings = settings;
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), DiscoveryNode.isRemoteClusterClient((Settings)settings) ? new RemoteClusterLicenseChecker(client, null) : null, ingestService, clusterService.getNodeName(), License.OperationMode.BASIC.description());
    }

    protected void doExecute(Task task, ValidateTransformAction.Request request, ActionListener<ValidateTransformAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        if (!request.isDeferValidation()) {
            TransformNodes.throwIfNoTransformNodes(clusterState);
            boolean requiresRemote = request.getConfig().getSource().requiresRemoteCluster();
            if (TransformNodes.redirectToAnotherNodeIfNeeded(clusterState, this.nodeSettings, requiresRemote, this.transportService, this.actionName, request, ValidateTransformAction.Response::new, listener)) {
                return;
            }
        }
        TransformNodes.warnIfNoTransformNodes(clusterState);
        TransformConfig config = request.getConfig();
        Function function = FunctionFactory.create(config);
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentClient = new ParentTaskAssigningClient(this.client, parentTaskId);
        if (config.getVersion() == null || config.getVersion().before((VersionId)TransformDeprecations.MIN_TRANSFORM_VERSION)) {
            listener.onFailure((Exception)new ValidationException().addValidationError(Strings.format((String)"Transform configuration is too old [%s], use the upgrade API to fix your transform. Minimum required version is [%s]", (Object[])new Object[]{config.getVersion(), TransformDeprecations.MIN_TRANSFORM_VERSION})));
            return;
        }
        ActionListener deduceMappingsListener = ActionListener.wrap(deducedMappings -> listener.onResponse((Object)new ValidateTransformAction.Response(deducedMappings)), deduceTargetMappingsException -> listener.onFailure((Exception)new RuntimeException("Failed to deduce dest mappings", (Throwable)deduceTargetMappingsException)));
        ActionListener validateQueryListener = ActionListener.wrap(validateQueryResponse -> {
            if (request.isDeferValidation()) {
                deduceMappingsListener.onResponse(Collections.emptyMap());
            } else {
                function.deduceMappings((Client)parentClient, config.getHeaders(), config.getId(), config.getSource(), (ActionListener<Map<String, String>>)deduceMappingsListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener validateConfigListener = ActionListener.wrap(validateConfigResponse -> {
            if (request.isDeferValidation()) {
                validateQueryListener.onResponse((Object)true);
            } else {
                function.validateQuery((Client)parentClient, config.getHeaders(), config.getSource(), request.ackTimeout(), (ActionListener<Boolean>)validateQueryListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener validateSourceDestListener = ActionListener.wrap(validateSourceDestResponse -> function.validateConfig((ActionListener<Boolean>)validateConfigListener), arg_0 -> listener.onFailure(arg_0));
        this.sourceDestValidator.validate(clusterState, config.getSource().getIndex(), config.getDestination().getIndex(), config.getDestination().getPipeline(), SourceDestValidations.getValidations(request.isDeferValidation(), config.getAdditionalSourceDestValidations()), validateSourceDestListener);
    }
}

