/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorApiKeyIdAction {
    public static final String NAME = "cluster:admin/xpack/connector/update_api_key_id";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/update_api_key_id");

    private UpdateConnectorApiKeyIdAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        @Nullable
        private final String apiKeyId;
        @Nullable
        private final String apiKeySecretId;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_api_key_id_request", false, (args, connectorId) -> new Request((String)connectorId, (String)args[0], (String)args[1]));

        public Request(String connectorId, String apiKeyId, String apiKeySecretId) {
            this.connectorId = connectorId;
            this.apiKeyId = apiKeyId;
            this.apiKeySecretId = apiKeySecretId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.apiKeyId = in.readOptionalString();
            this.apiKeySecretId = in.readOptionalString();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public String getApiKeyId() {
            return this.apiKeyId;
        }

        public String getApiKeySecretId() {
            return this.apiKeySecretId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (this.apiKeyId == null && this.apiKeySecretId == null) {
                validationException = ValidateActions.addValidationError((String)"[api_key_id] and [api_key_secret_id] cannot both be [null]. Please provide a value for at least one of them.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.apiKeyId != null) {
                builder.field(Connector.API_KEY_ID_FIELD.getPreferredName(), this.apiKeyId);
            }
            if (this.apiKeySecretId != null) {
                builder.field(Connector.API_KEY_SECRET_ID_FIELD.getPreferredName(), this.apiKeySecretId);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalString(this.apiKeyId);
            out.writeOptionalString(this.apiKeySecretId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.apiKeyId, request.apiKeyId) && Objects.equals(this.apiKeySecretId, request.apiKeySecretId);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.apiKeyId, this.apiKeySecretId);
        }

        static {
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.API_KEY_ID_FIELD);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.API_KEY_SECRET_ID_FIELD);
        }
    }
}

