/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetConnectorSecretResponse
extends ActionResponse
implements ToXContentObject {
    private final String id;
    private final String value;

    public GetConnectorSecretResponse(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.value = in.readString();
    }

    public GetConnectorSecretResponse(String id, String value) {
        this.id = id;
        this.value = value;
    }

    public String id() {
        return this.id;
    }

    public String value() {
        return this.value;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.value);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("value", this.value);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetConnectorSecretResponse that = (GetConnectorSecretResponse)((Object)o);
        return Objects.equals(this.id, that.id) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }
}

