/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.syncjob.action.ConnectorSyncJobActionRequest;

public class CheckInConnectorSyncJobAction {
    public static final String NAME = "cluster:admin/xpack/connector/sync_job/check_in";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/sync_job/check_in");

    private CheckInConnectorSyncJobAction() {
    }

    public static class Request
    extends ConnectorSyncJobActionRequest
    implements ToXContentObject {
        public static final ParseField CONNECTOR_SYNC_JOB_ID_FIELD = new ParseField("connector_sync_job_id", new String[0]);
        private final String connectorSyncJobId;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("check_in_connector_sync_job_request", false, args -> new Request((String)args[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorSyncJobId = in.readString();
        }

        public Request(String connectorSyncJobId) {
            this.connectorSyncJobId = connectorSyncJobId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorSyncJobId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_sync_job_id] of the connector sync job cannot be null or empty.", validationException);
            }
            return validationException;
        }

        public String getConnectorSyncJobId() {
            return this.connectorSyncJobId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorSyncJobId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorSyncJobId, request.connectorSyncJobId);
        }

        public int hashCode() {
            return Objects.hash(this.connectorSyncJobId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CONNECTOR_SYNC_JOB_ID_FIELD.getPreferredName(), this.connectorSyncJobId);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CONNECTOR_SYNC_JOB_ID_FIELD);
        }
    }
}

