/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.server.cli.ProcessUtil;

class ErrorPumpThread
extends Thread
implements Closeable {
    private final BufferedReader reader;
    private final Terminal terminal;
    private final CountDownLatch readyOrDead = new CountDownLatch(1);
    private volatile boolean ready;
    private volatile IOException ioFailure;
    List<String> filter = List.of("WARNING: Using incubator modules: jdk.incubator.vector");

    ErrorPumpThread(Terminal terminal, InputStream errInput) {
        super("server-cli[stderr_pump]");
        this.reader = new BufferedReader(new InputStreamReader(errInput, StandardCharsets.UTF_8));
        this.terminal = terminal;
    }

    private void checkForIoFailure() throws IOException {
        IOException failure = this.ioFailure;
        this.ioFailure = null;
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void close() throws IOException {
        assert (!this.isAlive()) : "Pump thread must be drained first";
        this.checkForIoFailure();
    }

    boolean waitUntilReady() throws IOException {
        ProcessUtil.nonInterruptibleVoid(this.readyOrDead::await);
        this.checkForIoFailure();
        return this.ready;
    }

    void drain() {
        ProcessUtil.nonInterruptibleVoid(this::join);
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) == '\u0018') {
                    this.ready = true;
                    this.readyOrDead.countDown();
                    continue;
                }
                if (this.filter.contains(line)) continue;
                this.terminal.errorPrintln(Terminal.Verbosity.SILENT, line, false);
            }
        }
        catch (IOException e) {
            this.ioFailure = e;
        }
        finally {
            this.terminal.flush();
            this.readyOrDead.countDown();
        }
    }
}

