/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.server.cli.ErrorPumpThread;
import org.elasticsearch.server.cli.ServerProcess;

public class ServerProcessBuilder {
    private Path tempDir;
    private ServerArgs serverArgs;
    private ProcessInfo processInfo;
    private List<String> jvmOptions;
    private Terminal terminal;

    public ServerProcessBuilder withTempDir(Path tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    public ServerProcessBuilder withProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
        return this;
    }

    public ServerProcessBuilder withServerArgs(ServerArgs serverArgs) {
        this.serverArgs = serverArgs;
        return this;
    }

    public ServerProcessBuilder withJvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public ServerProcessBuilder withTerminal(Terminal terminal) {
        this.terminal = terminal;
        return this;
    }

    private Map<String, String> getEnvironment() {
        HashMap<String, String> envVars = new HashMap<String, String>(this.processInfo.envVars());
        envVars.remove("ES_TMPDIR");
        if (!envVars.containsKey("LIBFFI_TMPDIR")) {
            envVars.put("LIBFFI_TMPDIR", this.tempDir.toString());
        }
        envVars.remove("ES_JAVA_OPTS");
        return envVars;
    }

    private List<String> getJvmArgs() {
        Path esHome = this.processInfo.workingDir();
        return List.of("--module-path", esHome.resolve("lib").toString(), "--add-modules=jdk.net", "--add-modules=jdk.management.agent", "--add-modules=ALL-MODULE-PATH", "-m", "org.elasticsearch.server/org.elasticsearch.bootstrap.Elasticsearch");
    }

    private String getCommand() {
        Path javaHome = PathUtils.get((String)((String)this.processInfo.sysprops().get("java.home")), (String[])new String[0]);
        boolean isWindows = ((String)this.processInfo.sysprops().get("os.name")).startsWith("Windows");
        return javaHome.resolve("bin").resolve("java" + (isWindows ? ".exe" : "")).toString();
    }

    public ServerProcess start() throws UserException {
        return this.start(ProcessBuilder::start);
    }

    private static void checkRequiredArgument(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalStateException(Strings.format((String)"'%s' is a required argument and needs to be specified before calling start()", (Object[])new Object[]{argumentName}));
        }
    }

    ServerProcess start(ProcessStarter processStarter) throws UserException {
        ErrorPumpThread errorPump;
        ServerProcessBuilder.checkRequiredArgument(this.tempDir, "tempDir");
        ServerProcessBuilder.checkRequiredArgument(this.serverArgs, "serverArgs");
        ServerProcessBuilder.checkRequiredArgument(this.processInfo, "processInfo");
        ServerProcessBuilder.checkRequiredArgument(this.jvmOptions, "jvmOptions");
        ServerProcessBuilder.checkRequiredArgument(this.terminal, "terminal");
        Process jvmProcess = null;
        boolean success = false;
        try {
            jvmProcess = ServerProcessBuilder.createProcess(this.getCommand(), this.getJvmArgs(), this.jvmOptions, this.getEnvironment(), processStarter);
            errorPump = new ErrorPumpThread(this.terminal, jvmProcess.getErrorStream());
            errorPump.start();
            ServerProcessBuilder.sendArgs(this.serverArgs, jvmProcess.getOutputStream());
            boolean serverOk = errorPump.waitUntilReady();
            if (!serverOk) {
                int exitCode = jvmProcess.waitFor();
                throw new UserException(exitCode, "Elasticsearch died while starting up");
            }
            success = true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success && jvmProcess != null && jvmProcess.isAlive()) {
                jvmProcess.destroyForcibly();
            }
        }
        return new ServerProcess(jvmProcess, errorPump);
    }

    private static Process createProcess(String command, List<String> jvmArgs, List<String> jvmOptions, Map<String, String> environment, ProcessStarter processStarter) throws InterruptedException, IOException {
        ProcessBuilder builder = new ProcessBuilder(Stream.concat(Stream.of(command), Stream.concat(jvmOptions.stream(), jvmArgs.stream())).toList());
        builder.environment().putAll(environment);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        return processStarter.start(builder);
    }

    private static void sendArgs(ServerArgs args, OutputStream processStdin) {
        OutputStreamStreamOutput out = new OutputStreamStreamOutput(processStdin);
        try {
            args.writeTo((StreamOutput)out);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static interface ProcessStarter {
        public Process start(ProcessBuilder var1) throws IOException;
    }
}

