/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Queue;
import java.util.concurrent.Semaphore;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.TransportException;

public final class FailureCollector {
    private final Queue<Exception> cancelledExceptions = ConcurrentCollections.newQueue();
    private final Semaphore cancelledExceptionsPermits;
    private final Queue<Exception> nonCancelledExceptions = ConcurrentCollections.newQueue();
    private final Semaphore nonCancelledExceptionsPermits;
    private volatile boolean hasFailure = false;
    private Exception finalFailure = null;

    public FailureCollector() {
        this(10);
    }

    public FailureCollector(int maxExceptions) {
        if (maxExceptions <= 0) {
            throw new IllegalArgumentException("maxExceptions must be at least one");
        }
        this.cancelledExceptionsPermits = new Semaphore(maxExceptions);
        this.nonCancelledExceptionsPermits = new Semaphore(maxExceptions);
    }

    private static Exception unwrapTransportException(TransportException te) {
        Throwable cause = te.getCause();
        if (cause == null) {
            return te;
        }
        if (cause instanceof Exception) {
            Exception ex = (Exception)cause;
            return ex;
        }
        return new ElasticsearchException(cause);
    }

    public void unwrapAndCollect(Exception e) {
        if (e instanceof TransportException) {
            TransportException te = (TransportException)e;
            v0 = FailureCollector.unwrapTransportException(te);
        } else {
            v0 = e = e;
        }
        if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{TaskCancelledException.class}) != null) {
            if (this.nonCancelledExceptions.isEmpty() && this.cancelledExceptionsPermits.tryAcquire()) {
                this.cancelledExceptions.add(e);
            }
        } else if (this.nonCancelledExceptionsPermits.tryAcquire()) {
            this.nonCancelledExceptions.add(e);
            this.cancelledExceptions.clear();
        }
        this.hasFailure = true;
    }

    public boolean hasFailure() {
        return this.hasFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getFailure() {
        if (!this.hasFailure) {
            return null;
        }
        FailureCollector failureCollector = this;
        synchronized (failureCollector) {
            if (this.finalFailure == null) {
                this.finalFailure = this.buildFailure();
            }
            return this.finalFailure;
        }
    }

    private Exception buildFailure() {
        assert (this.hasFailure);
        assert (Thread.holdsLock(this));
        Exception first = null;
        for (Exception e : this.nonCancelledExceptions) {
            if (first == null) {
                first = e;
                continue;
            }
            if (first == e) continue;
            first.addSuppressed(e);
        }
        if (first != null) {
            return first;
        }
        for (Exception e : this.cancelledExceptions) {
            if (first == null) {
                first = e;
                continue;
            }
            if (first == e) continue;
            first.addSuppressed(e);
        }
        assert (first != null);
        return first;
    }
}

