/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSource;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExchangeSourceOperator
extends SourceOperator {
    private final ExchangeSource source;
    private IsBlockedResult isBlocked = NOT_BLOCKED;
    private int pagesEmitted;
    private long rowsEmitted;

    public ExchangeSourceOperator(ExchangeSource source) {
        this.source = source;
    }

    @Override
    public Page getOutput() {
        Page page = this.source.pollPage();
        if (page != null) {
            ++this.pagesEmitted;
            this.rowsEmitted += (long)page.getPositionCount();
        }
        return page;
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    @Override
    public void finish() {
        this.source.finish();
    }

    @Override
    public IsBlockedResult isBlocked() {
        if (this.isBlocked.listener().isDone()) {
            this.isBlocked = this.source.waitForReading();
            if (this.isBlocked.listener().isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public void close() {
        this.finish();
    }

    public String toString() {
        return "ExchangeSourceOperator";
    }

    @Override
    public Status status() {
        return new Status(this.source.bufferSize(), this.pagesEmitted, this.rowsEmitted);
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "exchange_source", Status::new);
        private final int pagesWaiting;
        private final int pagesEmitted;
        private final long rowsEmitted;

        Status(int pagesWaiting, int pagesEmitted, long rowsEmitted) {
            this.pagesWaiting = pagesWaiting;
            this.pagesEmitted = pagesEmitted;
            this.rowsEmitted = rowsEmitted;
        }

        Status(StreamInput in) throws IOException {
            this.pagesWaiting = in.readVInt();
            this.pagesEmitted = in.readVInt();
            this.rowsEmitted = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED) ? in.readVLong() : 0L;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.pagesWaiting);
            out.writeVInt(this.pagesEmitted);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED)) {
                out.writeVLong(this.rowsEmitted);
            }
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesWaiting() {
            return this.pagesWaiting;
        }

        public int pagesEmitted() {
            return this.pagesEmitted;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("pages_waiting", this.pagesWaiting);
            builder.field("pages_emitted", this.pagesEmitted);
            builder.field("rows_emitted", this.rowsEmitted);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.pagesWaiting == status.pagesWaiting && this.pagesEmitted == status.pagesEmitted && this.rowsEmitted == status.rowsEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.pagesWaiting, this.pagesEmitted, this.rowsEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }

    public record ExchangeSourceOperatorFactory(Supplier<ExchangeSource> exchangeSources) implements SourceOperator.SourceOperatorFactory
    {
        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new ExchangeSourceOperator(this.exchangeSources.get());
        }

        @Override
        public String describe() {
            return "ExchangeSourceOperator[]";
        }
    }
}

