/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.expression.gen.processor.FunctionalEnumBinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class BinaryStringStringProcessor
extends FunctionalEnumBinaryProcessor<String, String, Number, BinaryStringStringOperation> {
    public static final String NAME = "ss";

    public BinaryStringStringProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryStringStringOperation)i.readEnum(BinaryStringStringOperation.class));
    }

    public BinaryStringStringProcessor(Processor left, Processor right, BinaryStringStringOperation operation) {
        super(left, right, (Enum)operation);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected Object doProcess(Object left, Object right) {
        if (!(left instanceof String || left instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", left);
        }
        if (!(right instanceof String || right instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", right);
        }
        return super.doProcess((Object)left.toString(), (Object)right.toString());
    }

    public static enum BinaryStringStringOperation implements BiFunction<String, String, Number>
    {
        POSITION((sub, str) -> {
            int pos = str.indexOf((String)sub);
            return pos < 0 ? 0 : pos + 1;
        });

        private final BiFunction<String, String, Number> op;

        private BinaryStringStringOperation(BiFunction<String, String, Number> op) {
            this.op = op;
        }

        @Override
        public Number apply(String left, String right) {
            if (left == null || right == null) {
                return null;
            }
            return this.op.apply(left, right);
        }
    }
}

