/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.NonCollectingMultiMetricAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregationBuilder;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregator;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregatorSupplier;
import org.elasticsearch.xpack.analytics.boxplot.InternalBoxplot;

public class BoxplotAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double compression;
    private final TDigestExecutionHint executionHint;
    private final BoxplotAggregatorSupplier aggregatorSupplier;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(BoxplotAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, AnalyticsValuesSourceType.HISTOGRAM, TimeSeriesValuesSourceType.COUNTER), BoxplotAggregator::new, true);
    }

    BoxplotAggregatorFactory(String name, ValuesSourceConfig config, double compression, TDigestExecutionHint executionHint, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, BoxplotAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.compression = compression;
        this.executionHint = executionHint;
        this.aggregatorSupplier = aggregatorSupplier;
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        InternalBoxplot empty = InternalBoxplot.empty(this.name, this.compression, this.executionHint, this.config.format(), metadata);
        Predicate<String> hasMetric = InternalBoxplot.Metrics::hasMetric;
        return new NonCollectingMultiMetricAggregator(this.name, this.context, parent, (InternalNumericMetricsAggregation.MultiValue)empty, hasMetric, metadata);
    }

    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.config, this.config.format(), this.compression, this.executionHint, this.context, parent, metadata);
    }
}

