/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregationBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregator;
import org.elasticsearch.xpack.analytics.ttest.TTestStats;
import org.elasticsearch.xpack.analytics.ttest.TTestStatsBuilder;
import org.elasticsearch.xpack.analytics.ttest.UnpairedTTestState;

public class UnpairedTTestAggregator
extends TTestAggregator<UnpairedTTestState> {
    private final TTestStatsBuilder a = new TTestStatsBuilder(this.bigArrays());
    private final TTestStatsBuilder b = new TTestStatsBuilder(this.bigArrays());
    private final boolean homoscedastic;
    private final Supplier<Tuple<Weight, Weight>> weightsSupplier;

    UnpairedTTestAggregator(String name, MultiValuesSource.NumericMultiValuesSource valuesSources, int tails, boolean homoscedastic, Supplier<Tuple<Weight, Weight>> weightsSupplier, DocValueFormat format, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSources, tails, format, context, parent, metadata);
        this.weightsSupplier = weightsSupplier;
        this.homoscedastic = homoscedastic;
    }

    @Override
    protected UnpairedTTestState getState(long bucket) {
        TTestStats aTTestStats = this.a.getSize() > bucket ? this.a.get(bucket) : TTestStats.EMPTY;
        TTestStats bTTestStats = this.b.getSize() > bucket ? this.b.get(bucket) : TTestStats.EMPTY;
        return new UnpairedTTestState(aTTestStats, bTTestStats, this.homoscedastic, this.tails);
    }

    @Override
    protected UnpairedTTestState getEmptyState() {
        return new UnpairedTTestState(TTestStats.EMPTY, TTestStats.EMPTY, this.homoscedastic, this.tails);
    }

    @Override
    protected long size() {
        return this.a.getSize();
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDoubleValues docAValues = this.valuesSources.getField(TTestAggregationBuilder.A_FIELD.getPreferredName(), aggCtx.getLeafReaderContext());
        final SortedNumericDoubleValues docBValues = this.valuesSources.getField(TTestAggregationBuilder.B_FIELD.getPreferredName(), aggCtx.getLeafReaderContext());
        final CompensatedSum compSumA = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumOfSqrA = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumB = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compSumOfSqrB = new CompensatedSum(0.0, 0.0);
        Tuple<Weight, Weight> weights = this.weightsSupplier.get();
        final Bits bitsA = UnpairedTTestAggregator.getBits(aggCtx.getLeafReaderContext(), (Weight)weights.v1());
        final Bits bitsB = UnpairedTTestAggregator.getBits(aggCtx.getLeafReaderContext(), (Weight)weights.v2());
        return new LeafBucketCollectorBase(sub, docAValues){

            private void processValues(int doc, long bucket, SortedNumericDoubleValues docValues, CompensatedSum compSum, CompensatedSum compSumOfSqr, TTestStatsBuilder builder) throws IOException {
                if (docValues.advanceExact(doc)) {
                    builder.grow(UnpairedTTestAggregator.this.bigArrays(), bucket + 1L);
                    int numValues = docValues.docValueCount();
                    for (int i = 0; i < numValues; ++i) {
                        builder.addValue(compSum, compSumOfSqr, bucket, docValues.nextValue());
                    }
                }
            }

            public void collect(int doc, long bucket) throws IOException {
                if (bitsA == null || bitsA.get(doc)) {
                    this.processValues(doc, bucket, docAValues, compSumA, compSumOfSqrA, UnpairedTTestAggregator.this.a);
                }
                if (bitsB == null || bitsB.get(doc)) {
                    this.processValues(doc, bucket, docBValues, compSumB, compSumOfSqrB, UnpairedTTestAggregator.this.b);
                }
            }
        };
    }

    private static Bits getBits(LeafReaderContext ctx, Weight weight) throws IOException {
        if (weight == null) {
            return null;
        }
        return Lucene.asSequentialAccessBits((int)ctx.reader().maxDoc(), (ScorerSupplier)weight.scorerSupplier(ctx));
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.a, this.b});
    }
}

