/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.blobcache.BlobCacheUtils;
import org.elasticsearch.blobcache.common.BlobCacheBufferedIndexInput;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.blobcache.shared.SharedBytes;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Streams;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.BlobStoreCacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.blob.CachedBlob;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.ChecksumBlobContainerIndexInput;

public abstract class MetadataCachingIndexInput
extends BlobCacheBufferedIndexInput {
    protected static final ThreadLocal<ByteBuffer> writeBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(SharedBytes.MAX_BYTES_PER_WRITE));
    protected final CacheFileReference cacheFileReference;
    protected final SearchableSnapshotDirectory directory;
    private final long compoundFileOffset;
    protected final int defaultRangeSize;
    protected final int recoveryRangeSize;
    private long lastReadPosition;
    private long lastSeekPosition;
    private final ByteRange headerBlobCacheByteRange;
    private final ByteRange footerBlobCacheByteRange;
    private final Logger logger;
    private final boolean isCfs;
    protected final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final IOContext context;
    protected final IndexInputStats stats;
    private final long offset;
    private volatile boolean isClone;
    private AtomicBoolean closed;

    protected MetadataCachingIndexInput(Logger logger, String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long compoundFileOffset, long length, CacheFileReference cacheFileReference, int defaultRangeSize, int recoveryRangeSize, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(name, context, length);
        this.isCfs = IndexFileNames.matchesExtension((String)name, (String)"cfs");
        this.logger = Objects.requireNonNull(logger);
        this.fileInfo = Objects.requireNonNull(fileInfo);
        this.context = Objects.requireNonNull(context);
        assert (!fileInfo.metadata().hashEqualsContents()) : "this method should only be used with blobs that are NOT stored in metadata's hash field (fileInfo: " + String.valueOf(fileInfo) + ")";
        this.stats = Objects.requireNonNull(stats);
        this.offset = offset;
        this.closed = new AtomicBoolean(false);
        this.isClone = false;
        this.directory = Objects.requireNonNull(directory);
        this.cacheFileReference = cacheFileReference;
        this.compoundFileOffset = compoundFileOffset;
        this.defaultRangeSize = defaultRangeSize;
        this.recoveryRangeSize = recoveryRangeSize;
        this.lastReadPosition = offset;
        this.lastSeekPosition = offset;
        this.headerBlobCacheByteRange = Objects.requireNonNull(headerBlobCacheByteRange);
        this.footerBlobCacheByteRange = Objects.requireNonNull(footerBlobCacheByteRange);
        assert (offset >= compoundFileOffset);
        assert (this.getBufferSize() <= BlobStoreCacheService.DEFAULT_CACHED_BLOB_SIZE);
    }

    protected MetadataCachingIndexInput(MetadataCachingIndexInput input) {
        this(input.logger, "(clone of) " + String.valueOf((Object)input), input.directory, input.fileInfo, input.context, input.stats, input.offset, input.compoundFileOffset, input.length(), input.cacheFileReference, input.defaultRangeSize, input.recoveryRangeSize, input.headerBlobCacheByteRange, input.footerBlobCacheByteRange);
        this.isClone = true;
        try {
            this.seek(input.getFilePointer());
        }
        catch (IOException e) {
            assert (false) : e;
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean maybeReadChecksumFromFileInfo(BlobStoreIndexShardSnapshot.FileInfo fileInfo, long absolutePosition, boolean isClone, ByteBuffer b) throws IOException {
        int remaining = b.remaining();
        if (remaining > CodecUtil.footerLength()) {
            return false;
        }
        long checksumPosition = fileInfo.length() - (long)CodecUtil.footerLength();
        if (absolutePosition < checksumPosition) {
            return false;
        }
        if (isClone) {
            return false;
        }
        boolean success = false;
        try {
            int checksumOffset = BlobCacheUtils.toIntBytes((long)Math.subtractExact(absolutePosition, checksumPosition));
            assert (checksumOffset <= CodecUtil.footerLength()) : checksumOffset;
            assert (0 <= checksumOffset) : checksumOffset;
            byte[] checksum = ChecksumBlobContainerIndexInput.checksumToBytesArray(fileInfo.checksum());
            b.put(checksum, checksumOffset, remaining);
            success = true;
        }
        catch (NumberFormatException numberFormatException) {
            assert ((long)b.remaining() == (success ? 0L : (long)remaining)) : b.remaining() + " remaining bytes but success is " + success;
            catch (Throwable throwable) {
                assert ((long)b.remaining() == (success ? 0L : (long)remaining)) : b.remaining() + " remaining bytes but success is " + success;
                throw throwable;
            }
        }
        assert ((long)b.remaining() == (success ? 0L : (long)remaining)) : b.remaining() + " remaining bytes but success is " + success;
        return success;
    }

    public static boolean assertCurrentThreadMayAccessBlobStore() {
        return ThreadPool.assertCurrentThreadPool((String[])new String[]{"snapshot", "generic", "search", "searchable_snapshots_cache_fetch_async", "searchable_snapshots_cache_prewarming"});
    }

    public static boolean assertCurrentThreadIsNotCacheFetchAsync() {
        String threadName = Thread.currentThread().getName();
        assert (!threadName.contains("[searchable_snapshots_cache_fetch_async]")) : "expected the current thread [" + threadName + "] to belong to the cache fetch async thread pool";
        return true;
    }

    protected long getAbsolutePosition() {
        long position = this.getFilePointer() + this.offset;
        assert (position >= 0L) : "absolute position is negative: " + position;
        assert (position <= this.fileInfo.length()) : position + " vs " + this.fileInfo.length();
        return position;
    }

    protected abstract void readWithoutBlobCache(ByteBuffer var1) throws Exception;

    private ByteRange rangeToReadFromBlobCache(long position, int readLength) {
        long end = position + (long)readLength;
        if (this.headerBlobCacheByteRange.contains(position, end)) {
            return this.headerBlobCacheByteRange;
        }
        if (this.footerBlobCacheByteRange.contains(position, end)) {
            return this.footerBlobCacheByteRange;
        }
        return ByteRange.EMPTY;
    }

    private void readWithBlobCache(ByteBuffer b, ByteRange blobCacheByteRange) throws Exception {
        long position = this.getAbsolutePosition();
        int length = b.remaining();
        CacheFile cacheFile = this.cacheFileReference.get();
        Future<Integer> waitingForRead = cacheFile.readIfAvailableOrPending(ByteRange.of((long)position, (long)(position + (long)length)), chan -> {
            int read = this.readCacheFile(chan, position, b);
            assert (read == length) : read + " vs " + length;
            return read;
        });
        if (waitingForRead != null) {
            Integer read = waitingForRead.get();
            assert (read == length);
            return;
        }
        CachedBlob cachedBlob = this.directory.getCachedBlob(this.fileInfo.physicalName(), blobCacheByteRange);
        if (cachedBlob == CachedBlob.CACHE_MISS || cachedBlob == CachedBlob.CACHE_NOT_READY) {
            this.fillBlobCacheIndex(b, blobCacheByteRange, position, cacheFile);
        } else {
            this.readAndCopyFromBlobCacheIndex(b, position, cacheFile, cachedBlob);
        }
    }

    private void fillBlobCacheIndex(ByteBuffer b, ByteRange blobCacheByteRange, long position, CacheFile cacheFile) throws Exception {
        int length = b.remaining();
        Future<Integer> populateCacheFuture = this.populateAndRead(b, position, cacheFile, blobCacheByteRange);
        this.fillIndexCache(cacheFile, blobCacheByteRange);
        if (this.compoundFileOffset > 0L && blobCacheByteRange.equals((Object)this.headerBlobCacheByteRange) && !this.footerBlobCacheByteRange.isEmpty()) {
            this.fillIndexCache(cacheFile, this.footerBlobCacheByteRange);
        }
        int bytesRead = populateCacheFuture.get();
        assert (bytesRead == length) : bytesRead + " vs " + length;
    }

    private void readAndCopyFromBlobCacheIndex(ByteBuffer b, long position, CacheFile cacheFile, CachedBlob cachedBlob) throws IOException {
        BytesRef bytesRef;
        int length = b.remaining();
        int sliceOffset = BlobCacheUtils.toIntBytes((long)(position - cachedBlob.from()));
        assert ((long)(sliceOffset + length) <= cachedBlob.to()) : "reading " + length + " bytes from " + sliceOffset + " exceed cached blob max position " + cachedBlob.to();
        this.logger.trace("reading [{}] bytes of file [{}] at position [{}] using cache index", (Object)length, (Object)this.fileInfo.physicalName(), (Object)position);
        BytesRefIterator cachedBytesIterator = cachedBlob.bytes().slice(sliceOffset, length).iterator();
        int copiedBytes = 0;
        while ((bytesRef = cachedBytesIterator.next()) != null) {
            b.put(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            copiedBytes += bytesRef.length;
        }
        assert (copiedBytes == length) : "copied " + copiedBytes + " but expected " + length;
        this.stats.addIndexCacheBytesRead(cachedBlob.length());
        this.copyToCacheFile(cacheFile, cachedBlob);
    }

    private void copyToCacheFile(CacheFile cacheFile, CachedBlob cachedBlob) {
        try {
            ByteRange cachedRange = ByteRange.of((long)cachedBlob.from(), (long)cachedBlob.to());
            cacheFile.populateAndRead(cachedRange, cachedRange, channel -> cachedBlob.length(), (channel, from, to, progressUpdater) -> {
                BytesRef current;
                long startTimeNanos = this.stats.currentTimeNanos();
                BytesRefIterator iterator = cachedBlob.bytes().slice(BlobCacheUtils.toIntBytes((long)(from - cachedBlob.from())), BlobCacheUtils.toIntBytes((long)(to - from))).iterator();
                long writePosition = from;
                while ((current = iterator.next()) != null) {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(current.bytes, current.offset, current.length);
                    while (byteBuffer.remaining() > 0) {
                        writePosition += (long)MetadataCachingIndexInput.positionalWrite(channel, writePosition, byteBuffer);
                        progressUpdater.accept(writePosition);
                    }
                }
                assert (writePosition == to) : writePosition + " vs " + to;
                long endTimeNanos = this.stats.currentTimeNanos();
                this.stats.addCachedBytesWritten(to - from, endTimeNanos - startTimeNanos);
                this.logger.trace("copied bytes [{}-{}] of file [{}] from cache index to disk", (Object)from, (Object)to, (Object)this.fileInfo);
            }, this.directory.cacheFetchAsyncExecutor());
        }
        catch (Exception e) {
            this.logger.debug(() -> Strings.format((String)"failed to store bytes [%s-%s] of file [%s] obtained from index cache", (Object[])new Object[]{cachedBlob.from(), cachedBlob.to(), this.fileInfo}), (Throwable)e);
        }
    }

    protected Future<Integer> populateAndRead(ByteBuffer b, long position, CacheFile cacheFile, ByteRange rangeToWrite) {
        ByteRange rangeToRead = ByteRange.of((long)position, (long)(position + (long)b.remaining()));
        assert (rangeToRead.isSubRangeOf(rangeToWrite)) : String.valueOf(rangeToRead) + " vs " + String.valueOf(rangeToWrite);
        return cacheFile.populateAndRead(rangeToWrite, rangeToRead, channel -> this.readCacheFile(channel, position, b), (fc, start, end, progressUpdater) -> {
            assert (MetadataCachingIndexInput.assertFileChannelOpen(fc));
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"searchable_snapshots_cache_fetch_async"}));
            ByteBuffer copyBuffer = writeBuffer.get().clear();
            this.logger.trace("writing range [{}-{}] to cache file [{}]", (Object)start, (Object)end, (Object)this.cacheFileReference);
            long bytesCopied = 0L;
            long startTimeNanos = this.stats.currentTimeNanos();
            try (InputStream input = this.openInputStreamFromBlobStore(start, end - start);){
                int bytesRead;
                for (long remaining = end - start; remaining > 0L; remaining -= (long)bytesRead) {
                    bytesRead = BlobCacheUtils.readSafe((InputStream)input, (ByteBuffer)copyBuffer, (long)start, (long)remaining);
                    MetadataCachingIndexInput.positionalWrite(fc, start + bytesCopied, copyBuffer.flip());
                    copyBuffer.clear();
                    progressUpdater.accept(start + (bytesCopied += (long)bytesRead));
                }
                long endTimeNanos = this.stats.currentTimeNanos();
                this.stats.addCachedBytesWritten(bytesCopied, endTimeNanos - startTimeNanos);
            }
        }, this.directory.cacheFetchAsyncExecutor());
    }

    private void readComplete(long position, int length) {
        this.stats.incrementBytesRead(this.lastReadPosition, position, length);
        this.lastSeekPosition = this.lastReadPosition = position + (long)length;
    }

    private int readCacheFile(FileChannel fc, long position, ByteBuffer buffer) throws IOException {
        assert (MetadataCachingIndexInput.assertFileChannelOpen(fc));
        int bytesRead = Channels.readFromFileChannel((FileChannel)fc, (long)position, (ByteBuffer)buffer);
        if (bytesRead == -1) {
            BlobCacheUtils.throwEOF((long)position, (long)buffer.remaining());
        }
        this.stats.addCachedBytesRead(bytesRead);
        return bytesRead;
    }

    private void fillIndexCache(CacheFile cacheFile, ByteRange indexCacheMiss) {
        Releasable onCacheFillComplete = this.stats.addIndexCacheFill();
        Future<Integer> readFuture = cacheFile.readIfAvailableOrPending(indexCacheMiss, channel -> {
            int indexCacheMissLength = BlobCacheUtils.toIntBytes((long)indexCacheMiss.length());
            ByteBuffer byteBuffer = ByteBuffer.allocate(indexCacheMissLength);
            Channels.readFromFileChannelWithEofException((FileChannel)channel, (long)indexCacheMiss.start(), (ByteBuffer)byteBuffer);
            byteBuffer.flip();
            BytesReference content = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer);
            this.directory.putCachedBlob(this.fileInfo.physicalName(), indexCacheMiss, content, (ActionListener<Void>)ActionListener.releasing((Releasable)onCacheFillComplete));
            return indexCacheMissLength;
        });
        if (readFuture == null) {
            onCacheFillComplete.close();
        }
    }

    private static boolean assertFileChannelOpen(FileChannel fileChannel) {
        assert (fileChannel != null);
        assert (fileChannel.isOpen());
        return true;
    }

    @SuppressForbidden(reason="Use positional writes on purpose")
    protected static int positionalWrite(FileChannel fc, long start, ByteBuffer byteBuffer) throws IOException {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"searchable_snapshots_cache_fetch_async"}));
        return fc.write(byteBuffer, start);
    }

    private int readDirectlyIfAlreadyClosed(long position, ByteBuffer b, Exception e) throws IOException {
        if (e instanceof AlreadyClosedException || e.getCause() != null && e.getCause() instanceof AlreadyClosedException) {
            int n;
            block10: {
                int length = b.remaining();
                this.logger.trace("direct reading of range [{}-{}] for cache file [{}]", (Object)position, (Object)(position + (long)length), (Object)this.cacheFileReference);
                long startTimeNanos = this.stats.currentTimeNanos();
                InputStream input = this.openInputStreamFromBlobStore(position, length);
                try {
                    int bytesRead = Streams.read((InputStream)input, (ByteBuffer)b, (int)length);
                    if (bytesRead < length) {
                        BlobCacheUtils.throwEOF((long)position, (long)(length - bytesRead));
                    }
                    long endTimeNanos = this.stats.currentTimeNanos();
                    this.stats.addDirectBytesRead(bytesRead, endTimeNanos - startTimeNanos);
                    n = bytesRead;
                    if (input == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                }
                input.close();
            }
            return n;
        }
        throw new IOException("failed to read data from cache for [" + String.valueOf(this.cacheFileReference) + "]", e);
    }

    protected InputStream openInputStreamFromBlobStore(long position, long readLength) throws IOException {
        assert (MetadataCachingIndexInput.assertCurrentThreadMayAccessBlobStore());
        if ((long)this.fileInfo.numberOfParts() == 1L) {
            assert (position + readLength <= this.fileInfo.length()) : "cannot read [" + position + "-" + (position + readLength) + "] from [" + String.valueOf(this.fileInfo) + "]";
            this.stats.addBlobStoreBytesRequested(readLength);
            return this.directory.blobContainer().readBlob(OperationPurpose.SNAPSHOT_DATA, this.fileInfo.name(), position, readLength);
        }
        return this.openInputStreamMultipleParts(position, readLength);
    }

    private SlicedInputStream openInputStreamMultipleParts(final long position, final long readLength) {
        final int startPart = this.getPartNumberForPosition(position);
        final int endPart = this.getPartNumberForPosition(position + readLength - 1L);
        return new SlicedInputStream(endPart - startPart + 1){

            protected InputStream openSlice(int slice) throws IOException {
                int currentPart = startPart + slice;
                long startInPart = currentPart == startPart ? MetadataCachingIndexInput.this.getRelativePositionInPart(position) : 0L;
                long endInPart = currentPart == endPart ? MetadataCachingIndexInput.this.getRelativePositionInPart(position + readLength - 1L) + 1L : MetadataCachingIndexInput.this.fileInfo.partBytes(currentPart);
                long length = endInPart - startInPart;
                MetadataCachingIndexInput.this.stats.addBlobStoreBytesRequested(length);
                return MetadataCachingIndexInput.this.directory.blobContainer().readBlob(OperationPurpose.SNAPSHOT_DATA, MetadataCachingIndexInput.this.fileInfo.partName(currentPart), startInPart, length);
            }

            public boolean markSupported() {
                return false;
            }
        };
    }

    private int getPartNumberForPosition(long position) {
        int part;
        this.ensureValidPosition(position);
        int n = part = this.fileInfo.numberOfParts() == 1 ? 0 : Math.toIntExact(position / this.fileInfo.partSize().getBytes());
        assert (part <= this.fileInfo.numberOfParts()) : "part number [" + part + "] exceeds number of parts: " + this.fileInfo.numberOfParts();
        assert (part >= 0) : "part number [" + part + "] is negative";
        return part;
    }

    private long getRelativePositionInPart(long position) {
        this.ensureValidPosition(position);
        long pos = position % this.fileInfo.partSize().getBytes();
        assert (pos < this.fileInfo.partBytes(this.getPartNumberForPosition(pos))) : "position in part [" + pos + "] exceeds part's length";
        assert (pos >= 0L) : "position in part [" + pos + "] is negative";
        return pos;
    }

    private void ensureValidPosition(long position) {
        assert (position >= 0L && position < this.fileInfo.length()) : position + " vs " + this.fileInfo.length();
        if (position < 0L || position >= this.fileInfo.length()) {
            throw new IllegalArgumentException("Position [" + position + "] is invalid for a file of length [" + this.fileInfo.length() + "]");
        }
    }

    protected final void readInternal(ByteBuffer b) throws IOException {
        assert (MetadataCachingIndexInput.assertCurrentThreadIsNotCacheFetchAsync());
        int bytesToRead = b.remaining();
        if (MetadataCachingIndexInput.maybeReadChecksumFromFileInfo(this.fileInfo, this.getAbsolutePosition(), this.isClone, b)) {
            this.logger.trace("read footer of file [{}], bypassing all caches", (Object)this.fileInfo.physicalName());
        } else {
            long position;
            block9: {
                position = this.getAbsolutePosition();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("readInternal: read [{}-{}] ([{}] bytes) from [{}]", (Object)position, (Object)(position + (long)bytesToRead), (Object)bytesToRead, (Object)this);
                }
                try {
                    ByteRange blobCacheByteRange = this.rangeToReadFromBlobCache(position, bytesToRead);
                    if (blobCacheByteRange.isEmpty()) {
                        this.readWithoutBlobCache(b);
                    } else {
                        this.readWithBlobCache(b, blobCacheByteRange);
                    }
                }
                catch (Exception e) {
                    int alreadyRead = bytesToRead - b.remaining();
                    int bytesRead = this.readDirectlyIfAlreadyClosed(position + (long)alreadyRead, b, e);
                    if ($assertionsDisabled || alreadyRead + bytesRead == bytesToRead) break block9;
                    throw new AssertionError((Object)(alreadyRead + " + " + bytesRead + " vs " + bytesToRead));
                }
            }
            this.readComplete(position, bytesToRead);
        }
        assert ((long)b.remaining() == 0L) : b.remaining();
        this.stats.addLuceneBytesRead(bytesToRead);
    }

    protected void seekInternal(long pos) throws IOException {
        BlobCacheUtils.ensureSeek((long)pos, (IndexInput)this);
        long position = pos + this.offset;
        this.stats.incrementSeeks(this.lastSeekPosition, position);
        this.lastSeekPosition = position;
    }

    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true) && !this.isClone) {
            this.stats.incrementCloseCount();
            this.cacheFileReference.releaseOnClose();
        }
    }

    public IndexInput clone() {
        IndexInput bufferClone = this.tryCloneBuffer();
        if (bufferClone != null) {
            return bufferClone;
        }
        MetadataCachingIndexInput clone = (MetadataCachingIndexInput)super.clone();
        clone.closed = new AtomicBoolean(false);
        clone.isClone = true;
        return clone;
    }

    public String toString() {
        return super.toString() + "[length=" + this.length() + ", file pointer=" + this.getFilePointer() + ", offset=" + this.offset + "]";
    }

    protected String getFullSliceDescription(String sliceDescription) {
        String resourceDesc = super.toString();
        if (sliceDescription != null) {
            return "slice(" + sliceDescription + ") of " + resourceDesc;
        }
        return resourceDesc;
    }

    public IndexInput slice(String sliceName, long sliceOffset, long sliceLength) {
        ByteRange sliceFooterByteRange;
        ByteRange sliceHeaderByteRange;
        long sliceCompoundFileOffset;
        boolean sliceCompoundFile;
        ByteArrayIndexInput bufferSlice = this.trySliceBuffer(sliceName, sliceOffset, sliceLength);
        if (bufferSlice != null) {
            return bufferSlice;
        }
        BlobCacheUtils.ensureSlice((String)sliceName, (long)sliceOffset, (long)sliceLength, (IndexInput)this);
        boolean bl = sliceCompoundFile = this.isCfs && IndexFileNames.getExtension((String)sliceName) != null && this.compoundFileOffset == 0L && !this.isClone;
        if (sliceCompoundFile) {
            sliceCompoundFileOffset = this.offset + sliceOffset;
            sliceHeaderByteRange = this.directory.getBlobCacheByteRange(sliceName, sliceLength).shift(sliceCompoundFileOffset);
            sliceFooterByteRange = !sliceHeaderByteRange.isEmpty() && sliceHeaderByteRange.length() < sliceLength ? ByteRange.of((long)(sliceLength - (long)CodecUtil.footerLength()), (long)sliceLength).shift(sliceCompoundFileOffset) : ByteRange.EMPTY;
        } else {
            sliceCompoundFileOffset = this.compoundFileOffset;
            sliceHeaderByteRange = ByteRange.EMPTY;
            sliceFooterByteRange = ByteRange.EMPTY;
        }
        MetadataCachingIndexInput slice = this.doSlice(sliceName, this.offset + sliceOffset, sliceLength, sliceHeaderByteRange, sliceFooterByteRange, sliceCompoundFileOffset);
        slice.isClone = true;
        return slice;
    }

    protected abstract MetadataCachingIndexInput doSlice(String var1, long var2, long var4, ByteRange var6, ByteRange var7, long var8);

    static class CacheFileReference
    implements CacheFile.EvictionListener {
        private final long fileLength;
        private final CacheKey cacheKey;
        private final SearchableSnapshotDirectory directory;
        final AtomicReference<CacheFile> cacheFile = new AtomicReference();

        CacheFileReference(SearchableSnapshotDirectory directory, String fileName, long fileLength) {
            this.cacheKey = directory.createCacheKey(fileName);
            this.fileLength = fileLength;
            this.directory = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CacheFile get() throws Exception {
            CacheFile currentCacheFile = this.cacheFile.get();
            if (currentCacheFile != null) {
                return currentCacheFile;
            }
            CacheFile newCacheFile = this.directory.getCacheFile(this.cacheKey, this.fileLength);
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                currentCacheFile = this.cacheFile.get();
                if (currentCacheFile != null) {
                    return currentCacheFile;
                }
                newCacheFile.acquire(this);
                CacheFile previousCacheFile = this.cacheFile.getAndSet(newCacheFile);
                assert (previousCacheFile == null);
                return newCacheFile;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEviction(CacheFile evictedCacheFile) {
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                if (this.cacheFile.compareAndSet(evictedCacheFile, null)) {
                    evictedCacheFile.release(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseOnClose() {
            CacheFileReference cacheFileReference = this;
            synchronized (cacheFileReference) {
                CacheFile currentCacheFile = this.cacheFile.getAndSet(null);
                if (currentCacheFile != null) {
                    currentCacheFile.release(this);
                }
            }
        }

        public String toString() {
            return "CacheFileReference{cacheKey='" + String.valueOf(this.cacheKey) + "', fileLength=" + this.fileLength + ", acquired=" + (this.cacheFile.get() != null) + "}";
        }
    }
}

