/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import java.net.InetSocketAddress;
import java.util.function.BiPredicate;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;

@ChannelHandler.Sharable
public class AcceptChannelHandler
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final BiPredicate<String, InetSocketAddress> predicate;
    private final String profile;
    private final ThreadContext threadContext;

    public AcceptChannelHandler(BiPredicate<String, InetSocketAddress> predicate, String profile, ThreadContext threadContext) {
        this.predicate = predicate;
        this.profile = profile;
        this.threadContext = threadContext;
    }

    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
            boolean bl = this.predicate.test(this.profile, remoteAddress);
            return bl;
        }
    }

    public static interface AcceptPredicate
    extends BiPredicate<String, InetSocketAddress> {
        public void setBoundAddress(BoundTransportAddress var1);
    }
}

