/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.deprecation.DeprecatedIndexPredicate;
import org.elasticsearch.xpack.migrate.action.CancelReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.action.GetMigrationReindexStatusAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamTaskParams;

public class ReindexDataStreamTransportAction
extends HandledTransportAction<ReindexDataStreamAction.ReindexDataStreamRequest, AcknowledgedResponse> {
    private final PersistentTasksService persistentTasksService;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final Client client;

    @Inject
    public ReindexDataStreamTransportAction(TransportService transportService, ActionFilters actionFilters, PersistentTasksService persistentTasksService, ClusterService clusterService, Client client) {
        super("indices:admin/data_stream/reindex", true, transportService, actionFilters, ReindexDataStreamAction.ReindexDataStreamRequest::new, (Executor)transportService.getThreadPool().executor("generic"));
        this.transportService = transportService;
        this.persistentTasksService = persistentTasksService;
        this.clusterService = clusterService;
        this.client = client;
    }

    protected void doExecute(Task task, ReindexDataStreamAction.ReindexDataStreamRequest request, ActionListener<AcknowledgedResponse> listener) {
        String sourceDataStreamName = request.getSourceDataStream();
        Metadata metadata = this.clusterService.state().metadata();
        DataStream dataStream = (DataStream)metadata.dataStreams().get(sourceDataStreamName);
        if (dataStream == null) {
            listener.onFailure((Exception)new ResourceNotFoundException("Data stream named [{}] does not exist", new Object[]{sourceDataStreamName}));
            return;
        }
        int totalIndices = dataStream.getIndices().size();
        int totalIndicesToBeUpgraded = (int)dataStream.getIndices().stream().filter(DeprecatedIndexPredicate.getReindexRequiredPredicate((Metadata)metadata, (boolean)false, (boolean)dataStream.isSystem())).count();
        ReindexDataStreamTaskParams params = new ReindexDataStreamTaskParams(sourceDataStreamName, this.transportService.getThreadPool().absoluteTimeInMillis(), totalIndices, totalIndicesToBeUpgraded, ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.transportService.getThreadPool().getThreadContext(), (ClusterState)this.clusterService.state()));
        String persistentTaskId = this.getPersistentTaskId(sourceDataStreamName);
        PersistentTasksCustomMetadata.PersistentTask persistentTask = PersistentTasksCustomMetadata.getTaskWithId((ClusterState)this.clusterService.state(), (String)persistentTaskId);
        if (persistentTask == null) {
            this.startTask(listener, persistentTaskId, params);
        } else {
            GetMigrationReindexStatusAction.Request statusRequest = new GetMigrationReindexStatusAction.Request(sourceDataStreamName);
            statusRequest.setParentTask(task.getParentTaskId());
            this.client.execute((ActionType)GetMigrationReindexStatusAction.INSTANCE, (ActionRequest)statusRequest, listener.delegateFailureAndWrap((getListener, getResponse) -> {
                if (!getResponse.getEnrichedStatus().complete()) {
                    throw new ResourceAlreadyExistsException("Reindex task for data stream [{}] already exists", new Object[]{sourceDataStreamName});
                }
                CancelReindexDataStreamAction.Request cancelRequest = new CancelReindexDataStreamAction.Request(sourceDataStreamName);
                cancelRequest.setParentTask(task.getParentTaskId());
                this.client.execute((ActionType)CancelReindexDataStreamAction.INSTANCE, (ActionRequest)cancelRequest, getListener.delegateFailureAndWrap((cancelListener, cancelResponse) -> this.startTask((ActionListener<AcknowledgedResponse>)cancelListener, persistentTaskId, params)));
            }));
        }
    }

    private void startTask(ActionListener<AcknowledgedResponse> listener, String persistentTaskId, ReindexDataStreamTaskParams params) {
        this.persistentTasksService.sendStartRequest(persistentTaskId, "reindex-data-stream", (PersistentTaskParams)params, TimeValue.THIRTY_SECONDS, ActionListener.wrap(startedTask -> listener.onResponse((Object)AcknowledgedResponse.TRUE), arg_0 -> listener.onFailure(arg_0)));
    }

    private String getPersistentTaskId(String dataStreamName) throws ResourceAlreadyExistsException {
        return "reindex-data-stream-" + dataStreamName;
    }
}

