/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenResponse;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsNodesRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsResponse;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountNodesCredentialsAction;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.service.CompositeServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ElasticServiceAccounts;
import org.elasticsearch.xpack.security.authc.service.FileServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.IndexServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountTokenStore;

public class ServiceAccountService {
    private static final Logger logger = LogManager.getLogger(ServiceAccountService.class);
    private static final int MIN_TOKEN_SECRET_LENGTH = 10;
    private final Client client;
    private final IndexServiceAccountTokenStore indexServiceAccountTokenStore;
    private final CompositeServiceAccountTokenStore compositeServiceAccountTokenStore;

    public ServiceAccountService(Client client, FileServiceAccountTokenStore fileServiceAccountTokenStore, IndexServiceAccountTokenStore indexServiceAccountTokenStore) {
        this.client = client;
        this.indexServiceAccountTokenStore = indexServiceAccountTokenStore;
        this.compositeServiceAccountTokenStore = new CompositeServiceAccountTokenStore(List.of(fileServiceAccountTokenStore, indexServiceAccountTokenStore), client.threadPool().getThreadContext());
    }

    public static boolean isServiceAccountPrincipal(String principal) {
        return ElasticServiceAccounts.ACCOUNTS.containsKey(principal);
    }

    public static Collection<String> getServiceAccountPrincipals() {
        return ElasticServiceAccounts.ACCOUNTS.keySet();
    }

    public static Map<String, ServiceAccount> getServiceAccounts() {
        return Map.copyOf(ElasticServiceAccounts.ACCOUNTS);
    }

    public static ServiceAccountToken tryParseToken(SecureString bearerString) {
        try {
            if (bearerString == null) {
                return null;
            }
            return ServiceAccountToken.fromBearerString(bearerString);
        }
        catch (Exception e) {
            logger.trace("Cannot parse possible service account token", (Throwable)e);
            return null;
        }
    }

    public void authenticateToken(ServiceAccountToken serviceAccountToken, String nodeName, ActionListener<Authentication> listener) {
        logger.trace("attempt to authenticate service account token [{}]", (Object)serviceAccountToken.getQualifiedName());
        if (!"elastic".equals(serviceAccountToken.getAccountId().namespace())) {
            logger.debug("only [{}] service accounts are supported, but received [{}]", (Object)"elastic", (Object)serviceAccountToken.getAccountId().asPrincipal());
            listener.onFailure((Exception)((Object)ServiceAccountService.createAuthenticationException(serviceAccountToken)));
            return;
        }
        ServiceAccount account = ElasticServiceAccounts.ACCOUNTS.get(serviceAccountToken.getAccountId().asPrincipal());
        if (account == null) {
            logger.debug("the [{}] service account does not exist", (Object)serviceAccountToken.getAccountId().asPrincipal());
            listener.onFailure((Exception)((Object)ServiceAccountService.createAuthenticationException(serviceAccountToken)));
            return;
        }
        if (serviceAccountToken.getSecret().length() < 10) {
            logger.debug("failing authentication for service account token [{}], the provided credential has length [{}] but a token's secret value must be at least [{}] characters", (Object)serviceAccountToken.getQualifiedName(), (Object)serviceAccountToken.getSecret().length(), (Object)10);
            listener.onFailure((Exception)((Object)ServiceAccountService.createAuthenticationException(serviceAccountToken)));
            return;
        }
        this.compositeServiceAccountTokenStore.authenticate(serviceAccountToken, (ActionListener<ServiceAccountTokenStore.StoreAuthenticationResult>)ActionListener.wrap(storeAuthenticationResult -> {
            if (storeAuthenticationResult.isSuccess()) {
                listener.onResponse((Object)ServiceAccountService.createAuthentication(account, serviceAccountToken, storeAuthenticationResult.getTokenSource(), nodeName));
            } else {
                ElasticsearchSecurityException e = ServiceAccountService.createAuthenticationException(serviceAccountToken);
                logger.debug(e.getMessage());
                listener.onFailure((Exception)((Object)e));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void createIndexToken(Authentication authentication, CreateServiceAccountTokenRequest request, ActionListener<CreateServiceAccountTokenResponse> listener) {
        this.indexServiceAccountTokenStore.createToken(authentication, request, listener);
    }

    public void deleteIndexToken(DeleteServiceAccountTokenRequest request, ActionListener<Boolean> listener) {
        this.indexServiceAccountTokenStore.deleteToken(request, listener);
    }

    public void findTokensFor(GetServiceAccountCredentialsRequest request, ActionListener<GetServiceAccountCredentialsResponse> listener) {
        ServiceAccount.ServiceAccountId accountId = new ServiceAccount.ServiceAccountId(request.getNamespace(), request.getServiceName());
        this.findIndexTokens(accountId, listener);
    }

    public static void getRoleDescriptor(Authentication authentication, ActionListener<RoleDescriptor> listener) {
        assert (authentication.isServiceAccount()) : "authentication is not for service account: " + String.valueOf(authentication);
        String principal = authentication.getEffectiveSubject().getUser().principal();
        ServiceAccountService.getRoleDescriptorForPrincipal(principal, listener);
    }

    public static void getRoleDescriptorForPrincipal(String principal, ActionListener<RoleDescriptor> listener) {
        ServiceAccount account = ElasticServiceAccounts.ACCOUNTS.get(principal);
        if (account == null) {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("cannot load role for service account [" + principal + "] - no such service account", new Object[0])));
            return;
        }
        listener.onResponse((Object)account.roleDescriptor());
    }

    private static Authentication createAuthentication(ServiceAccount account, ServiceAccountToken token, TokenInfo.TokenSource tokenSource, String nodeName) {
        User user = account.asUser();
        return Authentication.newServiceAccountAuthentication((User)user, (String)nodeName, Map.of("_token_name", token.getTokenName(), "_token_source", tokenSource.name().toLowerCase(Locale.ROOT)));
    }

    private static ElasticsearchSecurityException createAuthenticationException(ServiceAccountToken serviceAccountToken) {
        return new ElasticsearchSecurityException("failed to authenticate service account [{}] with token name [{}]", RestStatus.UNAUTHORIZED, new Object[]{serviceAccountToken.getAccountId().asPrincipal(), serviceAccountToken.getTokenName()});
    }

    private void findIndexTokens(ServiceAccount.ServiceAccountId accountId, ActionListener<GetServiceAccountCredentialsResponse> listener) {
        this.indexServiceAccountTokenStore.findTokensFor(accountId, (ActionListener<Collection<TokenInfo>>)ActionListener.wrap(indexTokenInfos -> this.findFileTokens((Collection<TokenInfo>)indexTokenInfos, accountId, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void findFileTokens(Collection<TokenInfo> indexTokenInfos, ServiceAccount.ServiceAccountId accountId, ActionListener<GetServiceAccountCredentialsResponse> listener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)GetServiceAccountNodesCredentialsAction.INSTANCE, (ActionRequest)new GetServiceAccountCredentialsNodesRequest(accountId.namespace(), accountId.serviceName()), (ActionListener)ActionListener.wrap(fileTokensResponse -> listener.onResponse((Object)new GetServiceAccountCredentialsResponse(accountId.asPrincipal(), indexTokenInfos, fileTokensResponse)), arg_0 -> listener.onFailure(arg_0)));
    }
}

