/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.settings;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.settings.UpdateSecuritySettingsAction;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestUpdateSecuritySettingsAction
extends SecurityBaseRestHandler {
    public RestUpdateSecuritySettingsAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public String getName() {
        return "security_update_settings";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_security/settings"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateSecuritySettingsAction.Request req;
        try (XContentParser parser = request.contentParser();){
            req = UpdateSecuritySettingsAction.Request.parse((XContentParser)parser, (mainIndexSettings, tokensIndexSettings, profilesIndexSettings) -> new UpdateSecuritySettingsAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request), RestUtils.getAckTimeout((RestRequest)request), mainIndexSettings, tokensIndexSettings, profilesIndexSettings));
        }
        return restChannel -> client.execute(UpdateSecuritySettingsAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(restChannel));
    }
}

