/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.Murmur3Hasher;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class FingerprintProcessor
extends AbstractProcessor {
    public static final String TYPE = "fingerprint";
    static final byte[] DELIMITER = new byte[]{0};
    static final byte[] TRUE_BYTES = new byte[]{1};
    static final byte[] FALSE_BYTES = new byte[]{2};
    private final List<String> fields;
    private final String targetField;
    private final ThreadLocal<Hasher> threadLocalHasher;
    private final byte[] salt;
    private final boolean ignoreMissing;

    FingerprintProcessor(String tag, String description, List<String> fields, String targetField, byte[] salt, ThreadLocal<Hasher> threadLocalHasher, boolean ignoreMissing) {
        super(tag, description);
        this.fields = new ArrayList<String>(fields);
        this.fields.sort(Comparator.naturalOrder());
        this.targetField = targetField;
        this.threadLocalHasher = threadLocalHasher;
        this.salt = salt;
        this.ignoreMissing = ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Hasher hasher = this.threadLocalHasher.get();
        hasher.reset();
        hasher.update(this.salt);
        Stack<Object> values = new Stack<Object>();
        for (int k = this.fields.size() - 1; k >= 0; --k) {
            String field = this.fields.get(k);
            Object value = ingestDocument.getFieldValue(field, Object.class, true);
            if (value == null) {
                if (this.ignoreMissing) continue;
                throw new IllegalArgumentException("missing field [" + field + "] when calculating fingerprint");
            }
            values.push(value);
        }
        if (values.size() > 0) {
            while (!values.isEmpty()) {
                int k;
                Object value = values.pop();
                if (value instanceof List) {
                    List list = (List)value;
                    for (int k2 = list.size() - 1; k2 >= 0; --k2) {
                        values.push(list.get(k2));
                    }
                    continue;
                }
                if (value instanceof Set) {
                    Set set = (Set)value;
                    ArrayList setList = new ArrayList(set);
                    setList.sort(Comparator.naturalOrder());
                    for (k = setList.size() - 1; k >= 0; --k) {
                        values.push(setList.get(k));
                    }
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    ArrayList entryList = new ArrayList(map.entrySet());
                    entryList.sort(Map.Entry.comparingByKey(Comparator.naturalOrder()));
                    for (k = entryList.size() - 1; k >= 0; --k) {
                        values.push(entryList.get(k));
                    }
                    continue;
                }
                if (value instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)value;
                    hasher.update(DELIMITER);
                    hasher.update(FingerprintProcessor.toBytes(entry.getKey()));
                    values.push(entry.getValue());
                    continue;
                }
                hasher.update(DELIMITER);
                hasher.update(FingerprintProcessor.toBytes(value));
            }
            ingestDocument.setFieldValue(this.targetField, (Object)Base64.getEncoder().encodeToString(hasher.digest()));
        }
        return ingestDocument;
    }

    static byte[] toBytes(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return string.getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes;
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            byte[] intBytes = new byte[4];
            ByteUtils.writeIntLE((int)integer, (byte[])intBytes, (int)0);
            return intBytes;
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            byte[] longBytes = new byte[8];
            ByteUtils.writeLongLE((long)longValue, (byte[])longBytes, (int)0);
            return longBytes;
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            byte[] floatBytes = new byte[4];
            ByteUtils.writeFloatLE((float)floatValue.floatValue(), (byte[])floatBytes, (int)0);
            return floatBytes;
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            byte[] doubleBytes = new byte[8];
            ByteUtils.writeDoubleLE((double)doubleValue, (byte[])doubleBytes, (int)0);
            return doubleBytes;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? TRUE_BYTES : FALSE_BYTES;
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)value;
            byte[] zoneIdBytes = zdt.getZone().getId().getBytes(StandardCharsets.UTF_8);
            byte[] zdtBytes = new byte[32 + zoneIdBytes.length];
            ByteUtils.writeIntLE((int)zdt.getYear(), (byte[])zdtBytes, (int)0);
            ByteUtils.writeIntLE((int)zdt.getMonthValue(), (byte[])zdtBytes, (int)4);
            ByteUtils.writeIntLE((int)zdt.getDayOfMonth(), (byte[])zdtBytes, (int)8);
            ByteUtils.writeIntLE((int)zdt.getHour(), (byte[])zdtBytes, (int)12);
            ByteUtils.writeIntLE((int)zdt.getMinute(), (byte[])zdtBytes, (int)16);
            ByteUtils.writeIntLE((int)zdt.getSecond(), (byte[])zdtBytes, (int)20);
            ByteUtils.writeIntLE((int)zdt.getNano(), (byte[])zdtBytes, (int)24);
            ByteUtils.writeIntLE((int)zdt.getOffset().getTotalSeconds(), (byte[])zdtBytes, (int)28);
            System.arraycopy(zoneIdBytes, 0, zdtBytes, 32, zoneIdBytes.length);
            return zdtBytes;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            byte[] dateBytes = new byte[8];
            ByteUtils.writeLongLE((long)date.getTime(), (byte[])dateBytes, (int)0);
            return dateBytes;
        }
        if (value == null) {
            return new byte[0];
        }
        throw new IllegalArgumentException("cannot convert object of type [" + value.getClass().getName() + "] to bytes");
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public ThreadLocal<Hasher> getThreadLocalHasher() {
        return this.threadLocalHasher;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public String getType() {
        return TYPE;
    }

    public static interface Hasher {
        public void reset();

        public void update(byte[] var1);

        public byte[] digest();

        public String getAlgorithm();
    }

    static class MurmurHasher
    implements Hasher {
        public static final String METHOD = "MurmurHash3";
        private final Murmur3Hasher mh = new Murmur3Hasher(0L);

        private MurmurHasher() {
        }

        static Hasher getInstance(String method) throws NoSuchAlgorithmException {
            if (!method.equalsIgnoreCase(METHOD)) {
                throw new NoSuchAlgorithmException("supports only [MurmurHash3] as method");
            }
            return new MurmurHasher();
        }

        @Override
        public void reset() {
            this.mh.reset();
        }

        @Override
        public void update(byte[] input) {
            this.mh.update(input);
        }

        @Override
        public byte[] digest() {
            return this.mh.digest();
        }

        @Override
        public String getAlgorithm() {
            return Murmur3Hasher.getAlgorithm();
        }
    }

    static class MessageDigestHasher
    implements Hasher {
        private final MessageDigest md;

        private MessageDigestHasher(MessageDigest md) {
            this.md = md;
        }

        static Hasher getInstance(String method) throws NoSuchAlgorithmException {
            if (method.equalsIgnoreCase("MurmurHash3")) {
                return MurmurHasher.getInstance(method);
            }
            MessageDigest md = MessageDigest.getInstance(method);
            return new MessageDigestHasher(md);
        }

        @Override
        public void reset() {
            this.md.reset();
        }

        @Override
        public void update(byte[] input) {
            this.md.update(input);
        }

        @Override
        public byte[] digest() {
            return this.md.digest();
        }

        @Override
        public String getAlgorithm() {
            return this.md.getAlgorithm();
        }
    }

    public static final class Factory
    implements Processor.Factory {
        public static final String[] SUPPORTED_DIGESTS = new String[]{"MD5", "SHA-1", "SHA-256", "SHA-512", "MurmurHash3"};
        static final String DEFAULT_TARGET = "fingerprint";
        static final String DEFAULT_SALT = "";
        static final String DEFAULT_METHOD = "SHA-1";

        public FingerprintProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            List fields = ConfigurationUtils.readList((String)"fingerprint", (String)processorTag, config, (String)"fields");
            if (fields.size() < 1) {
                throw ConfigurationUtils.newConfigurationException((String)"fingerprint", (String)processorTag, (String)"fields", (String)"must specify at least one field");
            }
            String targetField = ConfigurationUtils.readStringProperty((String)"fingerprint", (String)processorTag, config, (String)"target_field", (String)"fingerprint");
            String salt = ConfigurationUtils.readStringProperty((String)"fingerprint", (String)processorTag, config, (String)"salt", (String)DEFAULT_SALT);
            byte[] saltBytes = Strings.hasText((String)salt) ? FingerprintProcessor.toBytes(salt) : new byte[]{};
            String method = ConfigurationUtils.readStringProperty((String)"fingerprint", (String)processorTag, config, (String)"method", (String)DEFAULT_METHOD);
            if (!Arrays.asList(SUPPORTED_DIGESTS).contains(method)) {
                throw ConfigurationUtils.newConfigurationException((String)"fingerprint", (String)processorTag, (String)"method", (String)String.format(Locale.ROOT, "[%s] must be one of the supported hash methods [%s]", method, Strings.arrayToCommaDelimitedString((Object[])SUPPORTED_DIGESTS)));
            }
            ThreadLocal<Hasher> threadLocalHasher = ThreadLocal.withInitial(() -> {
                try {
                    return MessageDigestHasher.getInstance(method);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("unexpected exception creating MessageDigest instance for [" + method + "]", e);
                }
            });
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)"fingerprint", (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new FingerprintProcessor(processorTag, description, fields, targetField, saltBytes, threadLocalHasher, ignoreMissing);
        }
    }
}

