/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.notifications;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessageFactory;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;

public abstract class AbstractAuditor<T extends AbstractAuditMessage> {
    public static final String All_RESOURCES_ID = "";
    private static final Logger logger = LogManager.getLogger(AbstractAuditor.class);
    static final int MAX_BUFFER_SIZE = 1000;
    protected static final TimeValue MASTER_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final OriginSettingClient client;
    private final String nodeName;
    private final String auditIndexWriteAlias;
    private final AbstractAuditMessageFactory<T> messageFactory;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final AtomicBoolean indexAndAliasCreated;
    private Queue<ToXContent> backlog;
    private final AtomicBoolean indexAndAliasCreationInProgress;
    private final ExecutorService executorService;

    protected AbstractAuditor(OriginSettingClient client, String auditIndexWriteAlias, String nodeName, AbstractAuditMessageFactory<T> messageFactory, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, ExecutorService executorService) {
        this.client = Objects.requireNonNull(client);
        this.auditIndexWriteAlias = Objects.requireNonNull(auditIndexWriteAlias);
        this.messageFactory = Objects.requireNonNull(messageFactory);
        this.nodeName = Objects.requireNonNull(nodeName);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
        this.backlog = new ConcurrentLinkedQueue<ToXContent>();
        this.indexAndAliasCreated = new AtomicBoolean();
        this.indexAndAliasCreationInProgress = new AtomicBoolean();
        this.executorService = executorService;
    }

    public void audit(Level level, String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, level, new Date(), this.nodeName));
    }

    public void info(String resourceId, String message) {
        this.audit(Level.INFO, resourceId, message);
    }

    public void warning(String resourceId, String message) {
        this.audit(Level.WARNING, resourceId, message);
    }

    public void error(String resourceId, String message) {
        this.audit(Level.ERROR, resourceId, message);
    }

    public void reset() {
        this.indexAndAliasCreated.set(false);
        if (this.backlog == null) {
            this.backlog = new ConcurrentLinkedQueue<ToXContent>();
        }
    }

    private static void onIndexResponse(DocWriteResponse response) {
        logger.trace("Successfully wrote audit message");
    }

    private static void onIndexFailure(Exception exception) {
        logger.debug("Failed to write audit message", (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexDoc(ToXContent toXContent) {
        if (this.indexAndAliasCreated.get()) {
            this.writeDoc(toXContent);
            return;
        }
        ActionListener createListener = ActionListener.wrap(success -> {
            this.indexAndAliasCreationInProgress.set(false);
            AbstractAuditor abstractAuditor = this;
            synchronized (abstractAuditor) {
                this.indexAndAliasCreated.set(true);
                this.writeBacklog();
            }
        }, e -> this.indexAndAliasCreationInProgress.set(false));
        AbstractAuditor abstractAuditor = this;
        synchronized (abstractAuditor) {
            if (!this.indexAndAliasCreated.get()) {
                assert (this.backlog != null);
                if (this.backlog != null) {
                    if (this.backlog.size() >= 1000) {
                        this.backlog.remove();
                    }
                    this.backlog.add(toXContent);
                } else {
                    logger.error("Latest audit template missing and audit message cannot be added to the backlog");
                }
                if (this.indexAndAliasCreationInProgress.compareAndSet(false, true)) {
                    this.installTemplateAndCreateIndex((ActionListener<Boolean>)createListener);
                }
            }
        }
    }

    private void writeDoc(ToXContent toXContent) {
        this.client.index(this.indexRequest(toXContent), ActionListener.wrap(AbstractAuditor::onIndexResponse, e -> {
            if (e instanceof IndexNotFoundException) {
                this.executorService.execute(() -> {
                    this.reset();
                    this.indexDoc(toXContent);
                });
            } else {
                AbstractAuditor.onIndexFailure(e);
            }
        }));
    }

    private IndexRequest indexRequest(ToXContent toXContent) {
        IndexRequest indexRequest = new IndexRequest(this.auditIndexWriteAlias);
        indexRequest.source(AbstractAuditor.toXContentBuilder(toXContent));
        indexRequest.timeout(TimeValue.timeValueSeconds((long)5L));
        indexRequest.setRequireAlias(true);
        return indexRequest;
    }

    private static XContentBuilder toXContentBuilder(ToXContent toXContent) {
        XContentBuilder xContentBuilder;
        block8: {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            try {
                xContentBuilder = toXContent.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
                if (jsonBuilder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonBuilder != null) {
                        try {
                            jsonBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonBuilder.close();
        }
        return xContentBuilder;
    }

    protected void clearBacklog() {
        this.backlog = null;
    }

    protected void writeBacklog() {
        assert (this.backlog != null);
        if (this.backlog == null) {
            logger.debug("Message back log has already been written");
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        ToXContent doc = this.backlog.poll();
        while (doc != null) {
            bulkRequest.add(this.indexRequest(doc));
            doc = this.backlog.poll();
        }
        this.client.bulk(bulkRequest, ActionListener.wrap(bulkItemResponses -> {
            if (bulkItemResponses.hasFailures()) {
                logger.warn("Failures bulk indexing the message back log: {}", (Object)bulkItemResponses.buildFailureMessage());
            } else {
                logger.trace("Successfully wrote audit message backlog");
            }
            this.backlog = null;
        }, AbstractAuditor::onIndexFailure));
    }

    int backLogSize() {
        return this.backlog.size();
    }

    private void installTemplateAndCreateIndex(ActionListener<Boolean> listener) {
        SubscribableListener.newForked(l -> MlIndexAndAlias.installIndexTemplateIfRequired(this.clusterService.state(), (Client)this.client, this.templateVersion(), this.putTemplateRequest(), (ActionListener<Boolean>)l)).andThen((l, success) -> {
            IndexDetails indexDetails = this.indexDetails();
            MlIndexAndAlias.createIndexAndAliasIfNecessary((Client)this.client, this.clusterService.state(), this.indexNameExpressionResolver, indexDetails.indexPrefix(), indexDetails.indexVersion(), this.auditIndexWriteAlias, MASTER_TIMEOUT, ActiveShardCount.DEFAULT, (ActionListener<Boolean>)l);
        }).addListener(listener);
    }

    protected abstract TransportPutComposableIndexTemplateAction.Request putTemplateRequest();

    protected abstract int templateVersion();

    protected abstract IndexDetails indexDetails();

    public record IndexDetails(String indexPrefix, String indexVersion) {
    }
}

