/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetDeploymentStatsAction
extends ActionType<Response> {
    public static final GetDeploymentStatsAction INSTANCE = new GetDeploymentStatsAction();
    public static final String NAME = "cluster:internal/xpack/ml/trained_models/deployments/stats/get";

    private GetDeploymentStatsAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        public static final ParseField DEPLOYMENT_STATS = new ParseField("deployment_stats", new String[0]);
        private final QueryPage<AssignmentStats> stats;

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, List<AssignmentStats> stats, long count) {
            super(taskFailures, nodeFailures);
            this.stats = new QueryPage<AssignmentStats>(stats, count, DEPLOYMENT_STATS);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.stats = new QueryPage(in, AssignmentStats::new);
        }

        public QueryPage<AssignmentStats> getStats() {
            return this.stats;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.stats.doXContentBody(builder, params);
            this.toXContentCommon(builder, params);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.stats.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.stats, response.stats);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.stats);
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final String deploymentId;
        private List<String> expandedIds;

        public Request(String deploymentId) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, InferModelAction.Request.DEPLOYMENT_ID);
            this.expandedIds = Collections.singletonList(deploymentId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.deploymentId = in.readString();
            this.expandedIds = in.readStringCollectionAsList();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.deploymentId);
            out.writeStringCollection(this.expandedIds);
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setExpandedIds(List<String> expandedIds) {
            this.expandedIds = expandedIds;
        }

        public boolean match(Task task) {
            return this.expandedIds.stream().anyMatch(taskId -> StartTrainedModelDeploymentAction.TaskMatcher.match(task, taskId));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.deploymentId, request.deploymentId) && Objects.equals(this.expandedIds, request.expandedIds);
        }

        public int hashCode() {
            return Objects.hash(this.deploymentId, this.expandedIds);
        }
    }
}

