/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;

public class PersistJobAction
extends ActionType<Response> {
    public static final PersistJobAction INSTANCE = new PersistJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/persist";

    private PersistJobAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        private final boolean persisted;

        public Response(boolean persisted) {
            super(null, null);
            this.persisted = persisted;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.persisted = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.persisted);
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.persisted == that.persisted;
        }

        public int hashCode() {
            return Objects.hash(this.persisted);
        }
    }

    public static class Request
    extends JobTaskRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
            in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(true);
        }

        public Request(String jobId) {
            super(jobId);
        }

        public boolean isBackGround() {
            return true;
        }

        public boolean isForeground() {
            return !this.isBackGround();
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.isBackGround());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && this.isBackGround() == other.isBackGround();
        }
    }
}

