/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.snapshot.upgrade;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.MlTaskParams;

public class SnapshotUpgradeTaskParams
implements PersistentTaskParams,
MlTaskParams {
    public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
    public static final ConstructingObjectParser<SnapshotUpgradeTaskParams, Void> PARSER = new ConstructingObjectParser("xpack/ml/job/snapshot/upgrade", true, a -> new SnapshotUpgradeTaskParams((String)a[0], (String)a[1]));
    public static final String NAME = "xpack/ml/job/snapshot/upgrade";
    private final String jobId;
    private final String snapshotId;

    public SnapshotUpgradeTaskParams(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.snapshotId = in.readString();
    }

    public SnapshotUpgradeTaskParams(String jobId, String snapshotId) {
        this.jobId = jobId;
        this.snapshotId = snapshotId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_11_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeString(this.snapshotId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotUpgradeTaskParams params = (SnapshotUpgradeTaskParams)o;
        return Objects.equals(this.jobId, params.jobId) && Objects.equals(this.snapshotId, params.snapshotId);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.snapshotId);
    }

    @Override
    public String getMlId() {
        return this.jobId;
    }

    public static SnapshotUpgradeTaskParams fromXContent(XContentParser parser) {
        return (SnapshotUpgradeTaskParams)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_ID);
    }
}

