/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;

public final class RoleMappingMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    private static final Logger logger = LogManager.getLogger(RoleMappingMetadata.class);
    public static final String TYPE = "role_mappings";
    public static final String METADATA_NAME_FIELD = "_es_reserved_role_mapping_name";
    public static final String FALLBACK_NAME = "name_not_available_after_deserialization";
    private static final ConstructingObjectParser<RoleMappingMetadata, Void> PARSER = new ConstructingObjectParser("role_mappings", args -> new RoleMappingMetadata(new LinkedHashSet<ExpressionRoleMapping>((Collection)args[0])));
    private static final RoleMappingMetadata EMPTY;
    private final Set<ExpressionRoleMapping> roleMappings;

    public static RoleMappingMetadata getFromClusterState(ClusterState clusterState) {
        return (RoleMappingMetadata)clusterState.metadata().custom(TYPE, (Metadata.Custom)EMPTY);
    }

    public RoleMappingMetadata(Set<ExpressionRoleMapping> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public RoleMappingMetadata(StreamInput input) throws IOException {
        this.roleMappings = input.readCollectionAsSet(ExpressionRoleMapping::new);
    }

    public Set<ExpressionRoleMapping> getRoleMappings() {
        return this.roleMappings;
    }

    public boolean isEmpty() {
        return this.roleMappings.isEmpty();
    }

    public ClusterState updateClusterState(ClusterState clusterState) {
        if (this.isEmpty()) {
            return clusterState.copyAndUpdateMetadata(b -> b.removeCustom(TYPE));
        }
        return clusterState.copyAndUpdateMetadata(b -> b.putCustom(TYPE, (Metadata.Custom)this));
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput streamInput) throws IOException {
        return RoleMappingMetadata.readDiffFrom(Metadata.Custom.class, (String)TYPE, (StreamInput)streamInput);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startArray((String)TYPE), this.roleMappings.iterator(), ChunkedToXContentHelper.endArray()});
    }

    public static RoleMappingMetadata fromXContent(XContentParser parser) throws IOException {
        return (RoleMappingMetadata)((Object)PARSER.apply(parser, null));
    }

    public String getWriteableName() {
        return TYPE;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.roleMappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RoleMappingMetadata other = (RoleMappingMetadata)((Object)o);
        return Objects.equals(this.roleMappings, other.roleMappings);
    }

    public int hashCode() {
        return Objects.hash(this.roleMappings);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RoleMapping[entries=[");
        Iterator<ExpressionRoleMapping> entryList = this.roleMappings.iterator();
        boolean firstEntry = true;
        while (entryList.hasNext()) {
            if (!firstEntry) {
                builder.append(",");
            }
            builder.append(entryList.next().toString());
            firstEntry = false;
        }
        return builder.append("]]").toString();
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public static ExpressionRoleMapping copyWithNameInMetadata(ExpressionRoleMapping roleMapping) {
        HashMap<String, Object> metadata = new HashMap<String, Object>(roleMapping.getMetadata());
        if (metadata.put(METADATA_NAME_FIELD, roleMapping.getName()) != null) {
            logger.error("Metadata field [{}] is reserved and will be overwritten with an internal system value. Rename this field in your role mapping configuration.", (Object)METADATA_NAME_FIELD);
        }
        return new ExpressionRoleMapping(roleMapping.getName(), roleMapping.getExpression(), roleMapping.getRoles(), roleMapping.getRoleTemplates(), metadata, roleMapping.isEnabled());
    }

    public static boolean hasFallbackName(ExpressionRoleMapping expressionRoleMapping) {
        return expressionRoleMapping.getName().equals(FALLBACK_NAME);
    }

    public boolean hasAnyMappingWithFallbackName() {
        return this.roleMappings.stream().anyMatch(RoleMappingMetadata::hasFallbackName);
    }

    public static ExpressionRoleMapping parseWithNameFromMetadata(XContentParser parser) throws IOException {
        ExpressionRoleMapping roleMapping = ExpressionRoleMapping.parse(FALLBACK_NAME, parser);
        return new ExpressionRoleMapping(RoleMappingMetadata.getNameFromMetadata(roleMapping), roleMapping.getExpression(), roleMapping.getRoles(), roleMapping.getRoleTemplates(), roleMapping.getMetadata(), roleMapping.isEnabled());
    }

    private static String getNameFromMetadata(ExpressionRoleMapping roleMapping) {
        Object object;
        Map<String, Object> metadata = roleMapping.getMetadata();
        if (metadata.containsKey(METADATA_NAME_FIELD) && (object = metadata.get(METADATA_NAME_FIELD)) instanceof String) {
            String name = (String)object;
            return name;
        }
        return FALLBACK_NAME;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> RoleMappingMetadata.parseWithNameFromMetadata(p), new ParseField(TYPE, new String[0]));
        EMPTY = new RoleMappingMetadata(Set.of());
    }
}

