/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions;

import java.io.IOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.core.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.actions.throttler.ActionThrottler;
import org.elasticsearch.xpack.core.watcher.actions.throttler.Throttler;
import org.elasticsearch.xpack.core.watcher.actions.throttler.ThrottlerField;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public class ActionWrapper
implements ToXContentObject {
    private String id;
    @Nullable
    private final ExecutableCondition condition;
    @Nullable
    private final ExecutableTransform<? extends Transform, ? extends Transform.Result> transform;
    private final ActionThrottler throttler;
    private final ExecutableAction<? extends Action> action;
    @Nullable
    private String path;
    private final Integer maxIterations;

    public ActionWrapper(String id, ActionThrottler throttler, @Nullable ExecutableCondition condition, @Nullable ExecutableTransform<? extends Transform, ? extends Transform.Result> transform, ExecutableAction<? extends Action> action, @Nullable String path, @Nullable Integer maxIterations) {
        this.id = id;
        this.condition = condition;
        this.throttler = throttler;
        this.transform = transform;
        this.action = action;
        this.path = path;
        this.maxIterations = maxIterations != null ? maxIterations : 100;
    }

    public String id() {
        return this.id;
    }

    public ExecutableCondition condition() {
        return this.condition;
    }

    public ExecutableTransform<? extends Transform, ? extends Transform.Result> transform() {
        return this.transform;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ExecutableAction<? extends Action> action() {
        return this.action;
    }

    public ActionWrapperResult execute(WatchExecutionContext ctx) {
        Throttler.Result throttleResult;
        ActionWrapperResult result = ctx.actionsResults().get(this.id);
        if (result != null) {
            return result;
        }
        if (!ctx.skipThrottling(this.id) && (throttleResult = this.throttler.throttle(this.id, ctx)).throttle()) {
            if (throttleResult.type() == Throttler.Type.ACK) {
                return new ActionWrapperResult(this.id, new Action.Result.Acknowledged(this.action.type(), throttleResult.reason()));
            }
            return new ActionWrapperResult(this.id, new Action.Result.Throttled(this.action.type(), throttleResult.reason()));
        }
        Condition.Result conditionResult = null;
        if (this.condition != null) {
            try {
                conditionResult = this.condition.execute(ctx);
                if (!conditionResult.met()) {
                    ctx.watch().status().actionStatus(this.id).resetAckStatus(ZonedDateTime.now(ZoneOffset.UTC));
                    return new ActionWrapperResult(this.id, conditionResult, null, new Action.Result.ConditionFailed(this.action.type(), "condition not met. skipping", new Object[0]));
                }
            }
            catch (RuntimeException e) {
                this.action.logger().error(() -> Strings.format((String)"failed to execute action [%s/%s]. failed to execute condition", (Object[])new Object[]{ctx.watch().id(), this.id}), (Throwable)e);
                return new ActionWrapperResult(this.id, new Action.Result.ConditionFailed(this.action.type(), "condition failed. skipping: {}", e.getMessage()));
            }
        }
        Payload payload = ctx.payload();
        Transform.Result transformResult = null;
        if (this.transform != null) {
            try {
                transformResult = this.transform.execute(ctx, payload);
                if (transformResult.status() == Transform.Result.Status.FAILURE) {
                    this.action.logger().error("failed to execute action [{}/{}]. failed to transform payload. {}", (Object)ctx.watch().id(), (Object)this.id, (Object)transformResult.reason());
                    String msg = "Failed to transform payload";
                    return new ActionWrapperResult(this.id, conditionResult, transformResult, new Action.Result.Failure(this.action.type(), msg, new Object[0]));
                }
                payload = transformResult.payload();
            }
            catch (Exception e) {
                this.action.logger().error(() -> Strings.format((String)"failed to execute action [%s/%s]. failed to transform payload.", (Object[])new Object[]{ctx.watch().id(), this.id}), (Throwable)e);
                return new ActionWrapperResult(this.id, conditionResult, null, new Action.Result.FailureWithException(this.action.type(), e));
            }
        }
        if (org.elasticsearch.common.Strings.isEmpty((CharSequence)this.path)) {
            try {
                Action.Result actionResult = this.action.execute(this.id, ctx, payload);
                return new ActionWrapperResult(this.id, conditionResult, transformResult, actionResult);
            }
            catch (Exception e) {
                this.action.logger().error(() -> Strings.format((String)"failed to execute action [%s/%s]", (Object[])new Object[]{ctx.watch().id(), this.id}), (Throwable)e);
                return new ActionWrapperResult(this.id, new Action.Result.FailureWithException(this.action.type(), e));
            }
        }
        try {
            Set statuses;
            final ArrayList<Action.Result> results = new ArrayList<Action.Result>();
            Object object = ObjectPath.eval((String)this.path, ActionWrapper.toMap(ctx));
            int runs = 0;
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                if (collection.isEmpty()) {
                    throw new ElasticsearchException("foreach object [{}] was an empty list, could not run any action", new Object[]{this.path});
                }
                for (Object o : collection) {
                    if (runs < this.maxIterations) {
                        if (o instanceof Map) {
                            results.add(this.action.execute(this.id, ctx, new Payload.Simple((Map)o)));
                        } else {
                            results.add(this.action.execute(this.id, ctx, new Payload.Simple("_value", o)));
                        }
                        ++runs;
                        continue;
                    }
                    break;
                }
            } else {
                if (object == null) {
                    throw new ElasticsearchException("specified foreach object was null: [{}]", new Object[]{this.path});
                }
                throw new ElasticsearchException("specified foreach object was not a an array/collection: [{}]", new Object[]{this.path});
            }
            Action.Result.Status status = (statuses = results.stream().map(Action.Result::status).collect(Collectors.toSet())).size() == 1 ? (Action.Result.Status)((Object)statuses.iterator().next()) : Action.Result.Status.PARTIAL_FAILURE;
            final int numberOfActionsExecuted = runs;
            return new ActionWrapperResult(this.id, conditionResult, transformResult, new Action.Result(this.action.type(), status){

                public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    builder.field("number_of_actions_executed", numberOfActionsExecuted);
                    builder.startArray(WatchField.FOREACH.getPreferredName());
                    for (Action.Result result : results) {
                        builder.startObject();
                        result.toXContent(builder, params);
                        builder.endObject();
                    }
                    builder.endArray();
                    builder.field(WatchField.MAX_ITERATIONS.getPreferredName(), ActionWrapper.this.maxIterations);
                    return builder;
                }
            });
        }
        catch (Exception e) {
            this.action.logger().error(() -> Strings.format((String)"failed to execute action [%s/%s]", (Object[])new Object[]{ctx.watch().id(), this.id}), (Throwable)e);
            return new ActionWrapperResult(this.id, new Action.Result.FailureWithException(this.action.type(), e));
        }
    }

    private static Map<String, Object> toMap(WatchExecutionContext ctx) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", ctx.id().value());
        model.put("watch_id", ctx.id().watchId());
        model.put("execution_time", ZonedDateTime.ofInstant(ctx.executionTime().toInstant(), ZoneOffset.UTC));
        model.put("trigger", ctx.triggerEvent().data());
        model.put("metadata", ctx.watch().metadata());
        model.put("vars", ctx.vars());
        if (ctx.payload().data() != null) {
            model.put("payload", ctx.payload().data());
        }
        return Map.of("ctx", model);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionWrapper that = (ActionWrapper)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.condition, that.condition) && Objects.equals(this.transform, that.transform) && Objects.equals(this.action, that.action);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.condition, this.transform, this.action);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        TimeValue throttlePeriod = this.throttler.throttlePeriod();
        if (throttlePeriod != null) {
            builder.humanReadableField(ThrottlerField.THROTTLE_PERIOD.getPreferredName(), ThrottlerField.THROTTLE_PERIOD_HUMAN.getPreferredName(), (Object)throttlePeriod);
        }
        if (this.condition != null) {
            builder.startObject(WatchField.CONDITION.getPreferredName()).field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        }
        if (this.transform != null) {
            builder.startObject(Transform.TRANSFORM.getPreferredName()).field(this.transform.type(), this.transform, params).endObject();
        }
        if (!org.elasticsearch.common.Strings.isEmpty((CharSequence)this.path)) {
            builder.field(WatchField.FOREACH.getPreferredName(), this.path);
            builder.field(WatchField.MAX_ITERATIONS.getPreferredName(), this.maxIterations);
        }
        builder.field(this.action.type(), this.action, params);
        return builder.endObject();
    }

    static ActionWrapper parse(String watchId, String actionId, XContentParser parser, ActionRegistry actionRegistry, Clock clock, XPackLicenseState licenseState) throws IOException {
        XContentParser.Token token;
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        ExecutableCondition condition = null;
        ExecutableTransform<? extends Transform, ? extends Transform.Result> transform = null;
        TimeValue throttlePeriod = null;
        String path = null;
        ExecutableAction<? extends Action> action = null;
        Integer maxIterations = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (WatchField.CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                condition = actionRegistry.getConditionRegistry().parseExecutable(watchId, parser);
                continue;
            }
            if (WatchField.FOREACH.match(currentFieldName, parser.getDeprecationHandler())) {
                path = parser.text();
                continue;
            }
            if (Transform.TRANSFORM.match(currentFieldName, parser.getDeprecationHandler())) {
                transform = actionRegistry.getTransformRegistry().parse(watchId, parser);
                continue;
            }
            if (ThrottlerField.THROTTLE_PERIOD.match(currentFieldName, parser.getDeprecationHandler())) {
                throttlePeriod = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (ThrottlerField.THROTTLE_PERIOD_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    throttlePeriod = WatcherDateTimeUtils.parseTimeValue(parser, ThrottlerField.THROTTLE_PERIOD_HUMAN.toString());
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse action [{}/{}]. failed to parse field [{}] as time value", (Throwable)pe, new Object[]{watchId, actionId, currentFieldName});
                }
            }
            if (WatchField.MAX_ITERATIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                maxIterations = parser.intValue();
                continue;
            }
            ActionFactory actionFactory = actionRegistry.factory(currentFieldName);
            if (actionFactory == null) {
                throw new ElasticsearchParseException("could not parse action [{}/{}]. unknown action type [{}]", new Object[]{watchId, actionId, currentFieldName});
            }
            action = actionFactory.parseExecutable(watchId, actionId, parser);
        }
        if (action == null) {
            throw new ElasticsearchParseException("could not parse watch action [{}/{}]. missing action type", new Object[]{watchId, actionId});
        }
        ActionThrottler throttler = new ActionThrottler(clock, throttlePeriod, licenseState);
        return new ActionWrapper(actionId, throttler, condition, transform, action, path, maxIterations);
    }
}

