/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;

public final class ToBooleanFromDoubleEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator d;

    public ToBooleanFromDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator d, DriverContext driverContext) {
        super(driverContext, source);
        this.d = d;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.d;
    }

    @Override
    public Block evalVector(Vector v) {
        DoubleVector vector = (DoubleVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBooleanBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBoolean(this.evalValue(vector, p));
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private boolean evalValue(DoubleVector container, int index) {
        double value = container.getDouble(index);
        return ToBoolean.fromDouble(value);
    }

    @Override
    public Block evalBlock(Block b) {
        DoubleBlock block = (DoubleBlock)b;
        int positionCount = block.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    boolean value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBoolean(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private boolean evalValue(DoubleBlock container, int index) {
        double value = container.getDouble(index);
        return ToBoolean.fromDouble(value);
    }

    public String toString() {
        return "ToBooleanFromDoubleEvaluator[d=" + String.valueOf(this.d) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.d);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory d;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory d) {
            this.source = source;
            this.d = d;
        }

        public ToBooleanFromDoubleEvaluator get(DriverContext context) {
            return new ToBooleanFromDoubleEvaluator(this.source, this.d.get(context), context);
        }

        public String toString() {
            return "ToBooleanFromDoubleEvaluator[d=" + String.valueOf(this.d) + "]";
        }
    }
}

