/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;

public final class ToBooleanFromStringEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator keyword;

    public ToBooleanFromStringEvaluator(Source source, EvalOperator.ExpressionEvaluator keyword, DriverContext driverContext) {
        super(driverContext, source);
        this.keyword = keyword;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.keyword;
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBooleanBlockWith(this.evalValue(vector, 0, scratchPad), positionCount);
        }
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBoolean(this.evalValue(vector, p, scratchPad));
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private boolean evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToBoolean.fromKeyword(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    boolean value = this.evalValue(block, i, scratchPad);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBoolean(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private boolean evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToBoolean.fromKeyword(value);
    }

    public String toString() {
        return "ToBooleanFromStringEvaluator[keyword=" + String.valueOf(this.keyword) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.keyword);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory keyword;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory keyword) {
            this.source = source;
            this.keyword = keyword;
        }

        public ToBooleanFromStringEvaluator get(DriverContext context) {
            return new ToBooleanFromStringEvaluator(this.source, this.keyword.get(context), context);
        }

        public String toString() {
            return "ToBooleanFromStringEvaluator[keyword=" + String.valueOf(this.keyword) + "]";
        }
    }
}

