/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContainsGeoSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithin;

public class SpatialContains
extends SpatialRelatesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialContains", SpatialContains::new);
    public static final SpatialRelationsContains GEO = new SpatialRelationsContains(SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "ST_Contains"));
    public static final SpatialRelationsContains CARTESIAN = new SpatialRelationsContains(SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("ST_Contains"));
    private static final Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorMap = new HashMap();

    @FunctionInfo(returnType={"boolean"}, description="Returns whether the first geometry contains the second geometry.\nThis is the inverse of the <<esql-st_within,ST_WITHIN>> function.", examples={@Example(file="spatial_shapes", tag="st_contains-airport_city_boundaries")})
    public SpatialContains(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.\nThe second parameter must also have the same coordinate system as the first.\nThis means it is not possible to combine `geo_*` and `cartesian_*` parameters.") Expression right) {
        this(source, left, right, false, false);
    }

    SpatialContains(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues);
    }

    private SpatialContains(StreamInput in) throws IOException {
        super(in, false, false);
    }

    public String getWriteableName() {
        return SpatialContains.ENTRY.name;
    }

    @Override
    public ShapeRelation queryRelation() {
        return ShapeRelation.CONTAINS;
    }

    @Override
    public SpatialContains withDocValues(boolean foundLeft, boolean foundRight) {
        boolean leftDV = this.leftDocValues || foundLeft;
        boolean rightDV = this.rightDocValues || foundRight;
        return new SpatialContains(this.source(), this.left(), this.right(), leftDV, rightDV);
    }

    protected SpatialContains replaceChildren(Expression newLeft, Expression newRight) {
        return new SpatialContains(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, SpatialContains::new, (Object)this.left(), (Object)this.right());
    }

    public Object fold(FoldContext ctx) {
        try {
            GeometryDocValueReader docValueReader = SpatialRelatesUtils.asGeometryDocValueReader(ctx, this.crsType(), this.left());
            Geometry rightGeom = SpatialRelatesUtils.makeGeometryFromLiteral(ctx, this.right());
            Component2D[] components = SpatialRelatesUtils.asLuceneComponent2Ds(this.crsType(), rightGeom);
            return this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO ? GEO.geometryRelatesGeometries(docValueReader, components) : CARTESIAN.geometryRelatesGeometries(docValueReader, components);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to fold constant fields: " + e.getMessage(), e);
        }
    }

    @Override
    Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules() {
        return evaluatorMap;
    }

    @Override
    public SpatialRelatesFunction surrogate() {
        if (this.left().foldable() && !this.right().foldable()) {
            return new SpatialWithin(this.source(), this.right(), this.left(), this.rightDocValues, this.leftDocValues);
        }
        return this;
    }

    static void processGeoSourceAndConstant(BooleanBlock.Builder results, int p, BytesRefBlock left, Component2D[] right) throws IOException {
        GEO.processSourceAndConstant(results, p, left, right);
    }

    static void processGeoSourceAndSource(BooleanBlock.Builder builder, int p, BytesRefBlock left, BytesRefBlock right) throws IOException {
        GEO.processSourceAndSource(builder, p, left, right);
    }

    static void processGeoPointDocValuesAndConstant(BooleanBlock.Builder builder, int p, LongBlock left, Component2D[] right) throws IOException {
        GEO.processPointDocValuesAndConstant(builder, p, left, right);
    }

    static void processGeoPointDocValuesAndSource(BooleanBlock.Builder builder, int p, LongBlock left, BytesRefBlock right) throws IOException {
        GEO.processPointDocValuesAndSource(builder, p, left, right);
    }

    static void processCartesianSourceAndConstant(BooleanBlock.Builder builder, int p, BytesRefBlock left, Component2D[] right) throws IOException {
        CARTESIAN.processSourceAndConstant(builder, p, left, right);
    }

    static void processCartesianSourceAndSource(BooleanBlock.Builder builder, int p, BytesRefBlock left, BytesRefBlock right) throws IOException {
        CARTESIAN.processSourceAndSource(builder, p, left, right);
    }

    static void processCartesianPointDocValuesAndConstant(BooleanBlock.Builder builder, int p, LongBlock left, Component2D[] right) throws IOException {
        CARTESIAN.processPointDocValuesAndConstant(builder, p, left, right);
    }

    static void processCartesianPointDocValuesAndSource(BooleanBlock.Builder builder, int p, LongBlock left, BytesRefBlock right) throws IOException {
        CARTESIAN.processPointDocValuesAndSource(builder, p, left, right);
    }

    static {
        for (DataType spatialType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoSourceAndConstantEvaluator.Factory::new)));
                if (!DataType.isSpatialPoint((DataType)spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsGeoPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
        for (DataType spatialType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianSourceAndConstantEvaluator.Factory::new)));
                if (!DataType.isSpatialPoint((DataType)spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantArrayFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialContainsCartesianPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
    }

    static final class SpatialRelationsContains
    extends SpatialRelatesFunction.SpatialRelations {
        SpatialRelationsContains(SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder, ShapeIndexer shapeIndexer) {
            super(ShapeField.QueryRelation.CONTAINS, spatialCoordinateType, encoder, shapeIndexer);
        }

        @Override
        protected boolean geometryRelatesGeometry(BytesRef left, BytesRef right) throws IOException {
            Component2D[] rightComponent2Ds = SpatialRelatesUtils.asLuceneComponent2Ds(this.crsType, this.fromBytesRef(right));
            return this.geometryRelatesGeometries(left, rightComponent2Ds);
        }

        @Override
        protected void processSourceAndSource(BooleanBlock.Builder builder, int position, BytesRefBlock left, BytesRefBlock right) throws IOException {
            if (right.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                this.processSourceAndConstant(builder, position, left, SpatialRelatesUtils.asLuceneComponent2Ds(this.crsType, right, position));
            }
        }

        @Override
        protected void processPointDocValuesAndSource(BooleanBlock.Builder builder, int position, LongBlock leftValue, BytesRefBlock rightValue) throws IOException {
            this.processPointDocValuesAndConstant(builder, position, leftValue, SpatialRelatesUtils.asLuceneComponent2Ds(this.crsType, rightValue, position));
        }

        private boolean geometryRelatesGeometries(BytesRef left, Component2D[] rightComponent2Ds) throws IOException {
            Geometry leftGeom = this.fromBytesRef(left);
            GeometryDocValueReader leftDocValueReader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, leftGeom);
            return this.geometryRelatesGeometries(leftDocValueReader, rightComponent2Ds);
        }

        private boolean geometryRelatesGeometries(GeometryDocValueReader leftDocValueReader, Component2D[] rightComponent2Ds) throws IOException {
            for (Component2D rightComponent2D : rightComponent2Ds) {
                if (this.geometryRelatesGeometry(leftDocValueReader, rightComponent2D)) continue;
                return false;
            }
            return true;
        }

        private void processSourceAndConstant(BooleanBlock.Builder builder, int position, BytesRefBlock left, Component2D[] right) throws IOException {
            if (left.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                GeometryDocValueReader reader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, left, position);
                builder.appendBoolean(this.geometryRelatesGeometries(reader, right));
            }
        }

        private void processPointDocValuesAndConstant(BooleanBlock.Builder builder, int position, LongBlock left, Component2D[] right) throws IOException {
            if (left.getValueCount(position) < 1) {
                builder.appendNull();
            } else {
                GeometryDocValueReader reader = SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, left, position, arg_0 -> ((SpatialCoordinateTypes)this.spatialCoordinateType).longAsPoint(arg_0));
                builder.appendBoolean(this.geometryRelatesGeometries(reader, right));
            }
        }
    }
}

