/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public class LookupJoin
extends Join
implements SurrogateLogicalPlan,
PostAnalysisVerificationAware,
TelemetryAware {
    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, List<Attribute> joinFields) {
        this(source, left, right, new JoinTypes.UsingJoinType(JoinTypes.LEFT, joinFields), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> joinFields, List<Attribute> leftFields, List<Attribute> rightFields) {
        this(source, left, right, new JoinConfig(type, joinFields, leftFields, rightFields));
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig joinConfig) {
        super(source, left, right, joinConfig);
    }

    @Override
    public LogicalPlan surrogate() {
        return new Join(this.source(), this.left(), this.right(), this.config());
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new LookupJoin(this.source(), left, right, this.config());
    }

    @Override
    protected NodeInfo<Join> info() {
        return NodeInfo.create((Node)this, LookupJoin::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.config().type(), this.config().matchFields(), this.config().leftFields(), this.config().rightFields());
    }

    @Override
    public String telemetryLabel() {
        return "LOOKUP JOIN";
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        super.postAnalysisVerification(failures);
        this.right().forEachDown(EsRelation.class, esr -> {
            Map<String, IndexMode> indexNameWithModes = esr.indexNameWithModes();
            if (indexNameWithModes.size() != 1) {
                failures.add(Failure.fail(esr, "invalid [{}] resolution in lookup mode to [{}] indices", esr.indexPattern(), indexNameWithModes.size()));
            } else if (indexNameWithModes.values().iterator().next() != IndexMode.LOOKUP) {
                failures.add(Failure.fail(esr, "invalid [{}] resolution in lookup mode to an index in [{}] mode", esr.indexPattern(), indexNameWithModes.values().iterator().next()));
            }
            if (!esr.concreteIndices().contains(esr.indexPattern())) {
                failures.add(Failure.fail(this, "Aliases and index patterns are not allowed for LOOKUP JOIN [{}]", esr.indexPattern()));
            }
        });
    }
}

