/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.local.ImmediateLocalSupplier;

public interface LocalSupplier
extends Supplier<Block[]>,
Writeable {
    public static final LocalSupplier EMPTY = new LocalSupplier(){

        @Override
        public Block[] get() {
            return BlockUtils.NO_BLOCKS;
        }

        public String toString() {
            return "EMPTY";
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(0);
        }

        public boolean equals(Object obj) {
            return obj == EMPTY;
        }

        public int hashCode() {
            return 0;
        }
    };

    public static LocalSupplier of(Block[] blocks) {
        return new ImmediateLocalSupplier(blocks);
    }

    public static LocalSupplier readFrom(PlanStreamInput in) throws IOException {
        Block[] blocks = in.readCachedBlockArray();
        return blocks.length == 0 ? EMPTY : LocalSupplier.of(blocks);
    }
}

