/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.kql.query.KqlQueryBuilder;

public class KqlQuery
extends Query {
    private static final Map<String, BiConsumer<KqlQueryBuilder, String>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(KqlQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), KqlQueryBuilder::timeZone), Map.entry(KqlQueryBuilder.DEFAULT_FIELD_FIELD.getPreferredName(), KqlQueryBuilder::defaultField), Map.entry(KqlQueryBuilder.CASE_INSENSITIVE_FIELD.getPreferredName(), (qb, s) -> qb.caseInsensitive(Booleans.parseBoolean((String)s))));
    private final String query;
    private final Map<String, String> options;

    public KqlQuery(Source source, String query) {
        this(source, query, null);
    }

    public KqlQuery(Source source, String query, Map<String, String> options) {
        super(source);
        this.query = query;
        this.options = options == null ? Collections.emptyMap() : options;
    }

    protected QueryBuilder asBuilder() {
        KqlQueryBuilder queryBuilder = new KqlQueryBuilder(this.query);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal kql query option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    public String query() {
        return this.query;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.options);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        KqlQuery other = (KqlQuery)((Object)obj);
        return Objects.equals(this.query, other.query) && Objects.equals(this.options, other.options);
    }

    protected String innerToString() {
        return this.query;
    }

    public boolean scorable() {
        return true;
    }
}

