/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.SuppressForbidden;

public class URLBlobContainer
extends AbstractBlobContainer {
    protected final URLBlobStore blobStore;
    protected final URL path;

    public URLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public URL url() {
        return this.path;
    }

    public boolean blobExists(OperationPurpose purpose, String blobName) {
        assert (false) : "should never be called for a read-only url repo";
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, String blobNamePrefix) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    public DeleteResult delete(OperationPurpose purpose) {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    public InputStream readBlob(OperationPurpose purpose, String name) throws IOException {
        try {
            return new BufferedInputStream(URLBlobContainer.getInputStream(new URL(this.path, name)), this.blobStore.bufferSizeInBytes());
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("blob object [" + name + "] not found");
        }
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void writeBlob(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void writeMetadataBlob(OperationPurpose purpose, String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void writeBlobAtomic(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void writeBlobAtomic(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @SuppressForbidden(reason="We call connect in doPrivileged and provide SocketPermission")
    private static InputStream getInputStream(URL url) throws IOException {
        try {
            return AccessController.doPrivileged(url::openStream);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public void compareAndExchangeRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        listener.onFailure((Exception)new UnsupportedOperationException("URL repositories do not support this operation"));
    }
}

