/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.url.FileURLBlobContainer;
import org.elasticsearch.common.blobstore.url.URLBlobContainer;
import org.elasticsearch.common.blobstore.url.http.HttpURLBlobContainer;
import org.elasticsearch.common.blobstore.url.http.URLHttpClient;
import org.elasticsearch.common.blobstore.url.http.URLHttpClientSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.CheckedFunction;

public class URLBlobStore
implements BlobStore {
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"repositories.uri.buffer_size", (ByteSizeValue)ByteSizeValue.of((long)100L, (ByteSizeUnit)ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final URL path;
    private final int bufferSizeInBytes;
    private final CheckedFunction<BlobPath, BlobContainer, MalformedURLException> blobContainerFactory;

    public URLBlobStore(Settings settings, URL path, URLHttpClient httpClient, URLHttpClientSettings httpClientSettings) {
        this.path = path;
        this.bufferSizeInBytes = (int)((ByteSizeValue)BUFFER_SIZE_SETTING.get(settings)).getBytes();
        String protocol = this.path.getProtocol();
        this.blobContainerFactory = protocol.equals("http") || protocol.equals("https") ? blobPath -> new HttpURLBlobContainer(this, (BlobPath)blobPath, this.buildPath((BlobPath)blobPath), httpClient, httpClientSettings) : (protocol.equals("file") ? blobPath -> new FileURLBlobContainer(this, (BlobPath)blobPath, this.buildPath((BlobPath)blobPath)) : blobPath -> new URLBlobContainer(this, (BlobPath)blobPath, this.buildPath((BlobPath)blobPath)));
    }

    public String toString() {
        return this.path.toString();
    }

    public URL path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public BlobContainer blobContainer(BlobPath blobPath) {
        try {
            return (BlobContainer)this.blobContainerFactory.apply((Object)blobPath);
        }
        catch (MalformedURLException ex) {
            throw new BlobStoreException("malformed URL " + String.valueOf(blobPath), (Throwable)ex);
        }
    }

    public void close() {
    }

    private URL buildPath(BlobPath relativePath) throws MalformedURLException {
        List paths = relativePath.parts();
        if (paths.isEmpty()) {
            return this.path();
        }
        URL blobPath = new URL(this.path, (String)paths.get(0) + "/");
        for (int i = 1; i < paths.size(); ++i) {
            blobPath = new URL(blobPath, (String)paths.get(i) + "/");
        }
        return blobPath;
    }
}

