/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiling.action.SubGroup;

final class StackTrace
implements ToXContentObject {
    private static final String[] PATH_FRAME_IDS = new String[]{"Stacktrace", "frame", "ids"};
    private static final String[] PATH_FRAME_TYPES = new String[]{"Stacktrace", "frame", "types"};
    static final int NATIVE_FRAME_TYPE = 3;
    static final int KERNEL_FRAME_TYPE = 4;
    int[] addressOrLines;
    String[] fileIds;
    String[] frameIds;
    int[] typeIds;
    SubGroup subGroups;
    double annualCO2Tons;
    double annualCostsUSD;
    long count;
    private static final int BASE64_FRAME_ID_LENGTH = 32;
    private static final String SAFE_BASE64_ENCODER = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234456789-_";
    private static final int[] SAFE_BASE64_DECODER = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 63, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

    StackTrace(int[] addressOrLines, String[] fileIds, String[] frameIds, int[] typeIds, double annualCO2Tons, double annualCostsUSD, long count) {
        this.addressOrLines = addressOrLines;
        this.fileIds = fileIds;
        this.frameIds = frameIds;
        this.typeIds = typeIds;
        this.annualCO2Tons = annualCO2Tons;
        this.annualCostsUSD = annualCostsUSD;
        this.count = count;
    }

    static int[] runLengthDecodeBase64Url(String input, int size, int capacity) {
        int value;
        int count;
        int n;
        int i;
        int[] output = new int[capacity];
        int multipleOf8 = size / 8;
        int remainder = size % 8;
        int j = 0;
        for (i = 0; i < multipleOf8 * 8; i += 8) {
            n = StackTrace.charCodeAt(input, i) << 26 | StackTrace.charCodeAt(input, i + 1) << 20 | StackTrace.charCodeAt(input, i + 2) << 14 | StackTrace.charCodeAt(input, i + 3) << 8 | StackTrace.charCodeAt(input, i + 4) << 2 | StackTrace.charCodeAt(input, i + 5) >> 4;
            count = n >> 24 & 0xFF;
            value = n >> 16 & 0xFF;
            Arrays.fill(output, j, j + count, value);
            j += count;
            count = n >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, value);
            j += count;
            n = (StackTrace.charCodeAt(input, i + 5) & 0xF) << 12 | StackTrace.charCodeAt(input, i + 6) << 6 | StackTrace.charCodeAt(input, i + 7);
            count = n >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, value);
            j += count;
        }
        if (remainder == 6) {
            n = StackTrace.charCodeAt(input, i) << 26 | StackTrace.charCodeAt(input, i + 1) << 20 | StackTrace.charCodeAt(input, i + 2) << 14 | StackTrace.charCodeAt(input, i + 3) << 8 | StackTrace.charCodeAt(input, i + 4) << 2 | StackTrace.charCodeAt(input, i + 5) >> 4;
            count = n >> 24 & 0xFF;
            value = n >> 16 & 0xFF;
            Arrays.fill(output, j, j + count, value);
            j += count;
            count = n >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, value);
        } else if (remainder == 3) {
            n = StackTrace.charCodeAt(input, i) << 12 | StackTrace.charCodeAt(input, i + 1) << 6 | StackTrace.charCodeAt(input, i + 2);
            count = (n >>= 2) >> 8 & 0xFF;
            value = n & 0xFF;
            Arrays.fill(output, j, j + count, value);
        }
        return output;
    }

    static int getAddressFromStackFrameID(String frameID) {
        int address = StackTrace.charCodeAt(frameID, 21) & 0xF;
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 22);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 23);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 24);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 25);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 26);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 27);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 28);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 29);
        address <<= 6;
        address += StackTrace.charCodeAt(frameID, 30);
        address <<= 6;
        return address += StackTrace.charCodeAt(frameID, 31);
    }

    private static int charCodeAt(String input, int i) {
        return SAFE_BASE64_DECODER[input.charAt(i) & 0x7F];
    }

    static String getFileIDFromStackFrameID(String frameID) {
        return frameID.substring(0, 21) + SAFE_BASE64_ENCODER.charAt(frameID.charAt(21) & 0x30);
    }

    public static StackTrace fromSource(Map<String, Object> source) {
        String inputFrameTypes;
        String inputFrameIDs = (String)ObjectPath.eval((String[])PATH_FRAME_IDS, source);
        if (inputFrameIDs == null) {
            inputFrameIDs = (String)source.get("Stacktrace.frame.ids");
        }
        if ((inputFrameTypes = (String)ObjectPath.eval((String[])PATH_FRAME_TYPES, source)) == null) {
            inputFrameTypes = (String)source.get("Stacktrace.frame.types");
        }
        int countsFrameIDs = inputFrameIDs.length() / 32;
        String[] fileIDs = new String[countsFrameIDs];
        String[] frameIDs = new String[countsFrameIDs];
        int[] addressOrLines = new int[countsFrameIDs];
        int i = 0;
        int pos = 0;
        while (i < countsFrameIDs) {
            String frameID;
            frameIDs[i] = frameID = inputFrameIDs.substring(pos, pos + 32);
            fileIDs[i] = StackTrace.getFileIDFromStackFrameID(frameID);
            addressOrLines[i] = StackTrace.getAddressFromStackFrameID(frameID);
            ++i;
            pos += 32;
        }
        int[] typeIDs = StackTrace.runLengthDecodeBase64Url(inputFrameTypes, inputFrameTypes.length(), countsFrameIDs);
        return new StackTrace(addressOrLines, fileIDs, frameIDs, typeIDs, 0.0, 0.0, 0L);
    }

    public void forNativeAndKernelFrames(Consumer<String> consumer) {
        for (int i = 0; i < this.fileIds.length; ++i) {
            int frameType = this.typeIds[i];
            if (frameType != 3 && frameType != 4) continue;
            consumer.accept(this.fileIds[i]);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("address_or_lines", (Object)this.addressOrLines);
        builder.field("file_ids", this.fileIds);
        builder.field("frame_ids", this.frameIds);
        builder.field("type_ids", (Object)this.typeIds);
        builder.field("annual_co2_tons", this.annualCO2Tons);
        builder.field("annual_costs_usd", this.annualCostsUSD);
        builder.field("count", this.count);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackTrace that = (StackTrace)o;
        return Arrays.equals(this.addressOrLines, that.addressOrLines) && Arrays.equals(this.fileIds, that.fileIds) && Arrays.equals(this.frameIds, that.frameIds) && Arrays.equals(this.typeIds, that.typeIds);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.addressOrLines);
        result = 31 * result + Arrays.hashCode(this.fileIds);
        result = 31 * result + Arrays.hashCode(this.frameIds);
        result = 31 * result + Arrays.hashCode(this.typeIds);
        return result;
    }
}

