/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.ResponseHandler;
import org.elasticsearch.xpack.core.ccr.action.PauseFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class TransportPauseFollowAction
extends AcknowledgedTransportMasterNodeAction<PauseFollowAction.Request> {
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportPauseFollowAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService) {
        super("cluster:admin/xpack/ccr/pause_follow", transportService, clusterService, threadPool, actionFilters, PauseFollowAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.persistentTasksService = persistentTasksService;
    }

    protected void masterOperation(Task task, PauseFollowAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        IndexMetadata followerIMD = state.metadata().index(request.getFollowIndex());
        if (followerIMD == null) {
            listener.onFailure((Exception)new IndexNotFoundException(request.getFollowIndex()));
            return;
        }
        if (followerIMD.getCustomData("ccr") == null) {
            listener.onFailure((Exception)new IllegalArgumentException("index [" + request.getFollowIndex() + "] is not a follower index"));
            return;
        }
        PersistentTasksCustomMetadata persistentTasksMetadata = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        if (persistentTasksMetadata == null) {
            listener.onFailure((Exception)new IllegalArgumentException("no shard follow tasks found"));
            return;
        }
        List<String> shardFollowTaskIds = persistentTasksMetadata.tasks().stream().filter(persistentTask -> "xpack/ccr/shard_follow_task".equals(persistentTask.getTaskName())).filter(persistentTask -> {
            ShardFollowTask shardFollowTask = (ShardFollowTask)persistentTask.getParams();
            return shardFollowTask.getFollowShardId().getIndexName().equals(request.getFollowIndex());
        }).map(PersistentTasksCustomMetadata.PersistentTask::getId).toList();
        if (shardFollowTaskIds.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("no shard follow tasks for [" + request.getFollowIndex() + "]"));
            return;
        }
        int i = 0;
        ResponseHandler responseHandler = new ResponseHandler(shardFollowTaskIds.size(), listener);
        for (String taskId : shardFollowTaskIds) {
            int taskSlot = i++;
            this.persistentTasksService.sendRemoveRequest(taskId, request.masterNodeTimeout(), responseHandler.getActionListener(taskSlot));
        }
    }

    protected ClusterBlockException checkBlock(PauseFollowAction.Request request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getFollowIndex());
    }
}

