/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction>
implements RestRequestFilter {
    private final Predicate<NodeFeature> clusterSupportsFeature;
    private static final Set<String> FILTERED_FIELDS = Set.of("source.remote.host.password");

    public RestReindexAction(Predicate<NodeFeature> clusterSupportsFeature) {
        super(ReindexAction.INSTANCE);
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_reindex"));
    }

    public String getName() {
        return "reindex_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request) throws IOException {
        ReindexRequest internal;
        if (request.hasParam("pipeline")) {
            throw new IllegalArgumentException("_reindex doesn't support [pipeline] as a query parameter. Specify it in the [dest] object instead.");
        }
        try (XContentParser parser = request.contentParser();){
            internal = ReindexRequest.fromXContent((XContentParser)parser, this.clusterSupportsFeature);
        }
        if (request.hasParam("scroll")) {
            internal.setScroll(TimeValue.parseTimeValue((String)request.param("scroll"), (String)"scroll"));
        }
        if (request.hasParam("require_alias")) {
            internal.setRequireAlias(request.paramAsBoolean("require_alias", false));
        }
        return internal;
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

