/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.Primitive64Matrix;

public final class FixedWeightsPortfolio
extends EquilibriumModel {
    private final Primitive64Matrix myWeights;

    public FixedWeightsPortfolio(FinancePortfolio.Context aContext, FinancePortfolio weightsPortfolio) {
        super(aContext);
        this.myWeights = (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{weightsPortfolio.getWeights()});
    }

    public FixedWeightsPortfolio(MarketEquilibrium aMarketEquilibrium, Primitive64Matrix assetWeightsInColumn) {
        super(aMarketEquilibrium);
        this.myWeights = assetWeightsInColumn;
    }

    private FixedWeightsPortfolio(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myWeights = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void calibrate(FinancePortfolio.Context targetReturns) {
        this.calibrate(this.myWeights, targetReturns.getAssetReturns());
    }

    public void calibrate(List<? extends Comparable<?>> targetReturns) {
        this.calibrate(this.myWeights, (Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{targetReturns}));
    }

    @Override
    protected Primitive64Matrix calculateAssetReturns() {
        return this.calculateAssetReturns(this.myWeights);
    }

    @Override
    protected Primitive64Matrix calculateAssetWeights() {
        return this.myWeights;
    }
}

